package hiro.yoshioka.sql;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh2.ReflectionPreparedStatement;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.ResourceCaptionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.notes.NotesRunnerMeta;
import hiro.yoshioka.sql.notes.NotesRunnerSelection;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBSequence;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.ResultSetHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;

public class DominoSQL implements ITransactionSQL {
	protected Log fLogger = LogFactory.getLog(getClass());
	boolean needsAuth;
	String host;
	Map<String, DBUserPass> dbPassWordMap = new LinkedHashMap<String, DBUserPass>();

	@SuppressWarnings("unused")
	private static final List<String> IMMUTABLE_LIST = Collections
			.unmodifiableList(new ArrayList<String>());
	private static final String ADMIN = "admin";
	private boolean capturing;
	DBRoot _root;
	private ConnectionProperties _info;
	ClassManager classManager;

	public DominoSQL(ClassManager classManager) {
		this.classManager = classManager;
	}

	public DatabaseType getDatabaseType() {
		return DatabaseType.DOMINO;
	}

	protected DBRoot getMetaData(ResourceCaptionRequest request) {
		DBRoot rt = null;
		IDBSchema schema = null;
		try {
			capturing = true;

			if (request.canceld()) {
				return null;
			}
			ExecutorService ex = Executors.newSingleThreadExecutor();
			Future<DBRoot> future = null;
			if (!request.grabOnlyTableResource) {
				future = ex.submit(new NotesRunnerMeta(classManager, request
						.getConnectionProperties()));
			} else {
				IDBTable table = (IDBTable) request.selectionResource;
				future = ex.submit(new NotesRunnerMeta(classManager, request
						.getConnectionProperties(), table));
			}
			try {
				_root = future.get();
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();

			fLogger.info("new DBRoot");

		} catch (Throwable e) {
			e.printStackTrace();
			fLogger.error(e);
			return null;
		} finally {
			capturing = false;
		}

		return _root;
	}

	public void addAuthenticate(String dbName, String user, String pass) {
		addAuthenticate(new DBUserPass(dbName, user, pass));
	}

	public void addAuthenticate(DBUserPass dup) {
		if (dup == null) {
			fLogger.warn("Nothing authenticate informain...");
		} else {
			dbPassWordMap.put(dup.db, dup);
			// NotesRunner db = notesRunnerMap.get(dup.db);
		}
	}

	private boolean hasAdminAuthenticate() {
		System.out.println(dbPassWordMap);
		return dbPassWordMap.containsKey(ADMIN);
	}

	public void addUser(String dbname, String username, String passwd) {
		// mongo.getDB(dbname).addUser(username, passwd.toCharArray());
	}

	public ResultSetDataHolder selectAll(String collectionName) {
		// return selectAll(currentDB, collectionName);
		return null;
	}

	public ResultSetDataHolder2 selectAll(DB targetDB, String collectionName) {
		DBCollection collection = targetDB.getCollection(collectionName);
		DBCursor cur = collection.find();

		Set<String> allKeySets = new LinkedHashSet<String>();
		List<DBObject> curList = new ArrayList<DBObject>();
		while (cur.hasNext()) {
			DBObject obj = cur.next();
			curList.add(obj);
			allKeySets.addAll(obj.keySet());
		}
		ResultSetDataHolder2 rdh = new ResultSetDataHolder2(
				allKeySets.toArray(new String[allKeySets.size()]), null);
		for (DBObject obj : curList) {
			StringRecordData[] record = new StringRecordData[allKeySets.size()];
			int iCol = 0;
			for (String key : allKeySets) {
				Object o = obj.get(key);
				if (o != null) {
					System.out.println(o.getClass());
				}
				if (obj.containsField(key)) {
					record[iCol] = new StringRecordData(StringUtil.nvl(obj
							.get(key)));
				} else {
					record[iCol] = new StringRecordData(null);
				}
				iCol++;
			}
			rdh.addRow(record);
		}
		return rdh;
	}

	public void init() throws SQLException {
		this.init(null);
	}

	public void init(String host) throws SQLException {
		fLogger.info("host:" + host);
		// mongo = null;
		// currentDB = null;
		// dbMap.clear();
		// this.host = host;
		// this.options = options;
		// try {
		// if (StringUtil.isEmpty(host)) {
		// mongo = new Mongo();
		// } else {
		// if (options == null) {
		// mongo = new Mongo(host);
		// } else {
		// mongo = new Mongo(host, options);
		// }
		// }
		// if (mongo != null) {
		// getDBWithAuth(ADMIN);
		// }
		// } catch (Exception e) {
		// throw new SQLException(e);
		// }
		System.out.println("========================");
	}

	// private DB getDBWithAuth(String name) {
	// DB db = dbMap.get(name);
	// if (db == null) {
	// db = mongo.getDB(name);
	// dbMap.put(name, db);
	// DBUserPass auth = dbPassWordMap.get(name);
	// if (auth != null) {
	// db.authenticate(auth.user, auth.pass.toCharArray());
	// }
	// }
	// return db;
	// }
	//
	// public DB setCurrentDB(String currentDBName) {
	// currentDB = getDBWithAuth(currentDBName);
	// System.out.println("========================");
	// return currentDB;
	// }

	@Override
	public void addConnectionListner(SqlBasicListener listner) {
		// TODO Auto-generated method stub

	}

	@Override
	public void addTracsactionListner(SqlTransactionListener listener) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean canDoOperation(SQLOperationType operation) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public DBRoot getCopyRoot() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetDataHolder getProcedures(String name) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DBRoot getRoot() {
		return _root;
	}

	@Override
	public ResultSetDataHolder getSchemas() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetDataHolder getTables(String text) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isCapturing() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean load(File f) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void removeConnetionListener(SqlBasicListener listner) {
		// TODO Auto-generated method stub

	}

	@Override
	public void removeTracsactionListner(SqlTransactionListener listener) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean save(File f) throws IOException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setBuildDate(String format) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setBuildTimeStamp(String format) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setRoot(DBRoot root) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean doOperation(SQLOperationType operation, Request request)
			throws SQLException {

		TransactionRequest treq = null;
		if (request instanceof TransactionRequest) {
			treq = (TransactionRequest) request;
		}
		ExecutorService ex = null;
		boolean retCode = true;
		switch (operation) {
		case CONNECT:
			ConnectionProperties prop = request.getConnectionProperties();
			connect(prop);
			break;
		case CLOSE:
			prop = request.getConnectionProperties();
			close();
			break;
		case RESOURCE_CAPTION:
			getMetaData((ResourceCaptionRequest) request);
			break;
		case EXPLAIN_PLAN:
			break;
		case SELECT_SESSION:
			break;
		case SELECT_LOCK:
			break;
		case UNID_EXECUTE_QUERY:
			ex = Executors.newSingleThreadExecutor();
			Set<String> s = new LinkedHashSet<String>();
			for (String unid : treq.getSQLStatements()) {
				if (unid.trim().length() > 0) {
					s.add(unid);
				}
			}
			Future<ResultSetDataHolder2> future = ex
					.submit(new NotesRunnerSelection(classManager, request
							.getConnectionProperties(), treq.getIDBTable(), s));
			try {
				treq.setRDH(future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
			break;

		case SELECT_ALL:
			ex = Executors.newSingleThreadExecutor();
			future = ex.submit(new NotesRunnerSelection(classManager, request
					.getConnectionProperties(), treq.getIDBTable(), treq
					.getMaxRownum()));
			try {
				treq.setRDH(future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
			break;
		case CREATE_TRIG_FNC_PROC:
			break;
		case WORST_SQL:
			break;
		case CHECK_VALIDATION:
			break;
		case PREPARED_EXECUTE_QUERY:
			ex = Executors.newSingleThreadExecutor();
			future = ex.submit(new NotesRunnerSelection(classManager, request
					.getConnectionProperties(), treq.getIDBTable(), treq
					.getMaxRownum()));
			try {
				treq.setRDH(future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
			break;

		case PREPARED_EXECUTE:
			break;
		default:
			System.out.println("what's this operation ? " + operation);
			break;
		}

		return retCode;

	}

	@Override
	public boolean cansel() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean commit() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public int count(String sqlStatement) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public ResultSetDataHolder2 counts(String[] sqlStatements)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean execute(String sqlStatement) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean execute(String sqlStatement, String[] args)
			throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public ResultSetDataHolder2 executePrepare(String sqlStatement,
			Object[] arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSet getAllData(IDBTable table) throws SQLException {
		return null;
	}

	@Override
	public ResultSetMetaCopy getTableMetaCopy(String name) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetMetaCopy getTableMetaCopy(String name, String[] strings) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean rollback() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean saveCsv(String sqlStatement, ResultSetHandler handler,
			CsvWriter writer) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setMaxRowNum(int max) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean trunsactionTime() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean execute(ReflectionPreparedStatement ref) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public ResultSetDataHolder2 executePrepareQuery(String sql_statement,
			String[] binds) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void executePrepareQueryByLine(String sql_statement,
			LineListener listner) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean connect(ConnectionProperties properties) throws SQLException {
		this._info = properties;
		addAuthenticate(properties.getAdminAuthenticate());
		addAuthenticate(properties.getAuthenticate());
		init(properties.getHost());
		properties.setConnected(true);
		return true;
	}

	@Override
	public boolean close() throws SQLException {
		// init(prop.getHost());
		this._info.setConnected(false);
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, IDBSchema original,
			boolean drop, boolean cascade) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, DBCrossRefference original,
			boolean drop, boolean cascade) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, IDBTable original,
			boolean drop, boolean cascade, boolean noSchema)
			throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, IDBSequence original,
			boolean drop, boolean cascade, boolean noSchema)
			throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public ResultSetDataHolder renameField(IDBColumn before, String afterName)
			throws SQLException {
		return null;
	}

	// public void insert(String collectionName, BasicDBObject doc) {
	// WriteResult result = currentDB.getCollection(collectionName)
	// .insert(doc);
	// System.out.println("result=" + result);
	// }

}
