package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.ast.sql.mongo.util.WolfMongoParserUtil;
import hiro.yoshioka.sql.engine.MongoTransactionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBTable;

import java.io.File;
import java.io.FileNotFoundException;

public class WolfMongoProposalParserUtil extends WolfMongoParserUtil implements
		IProposalableParserUtil {
	DBRoot root;

	public WolfMongoProposalParserUtil(File file, DBRoot root)
			throws FileNotFoundException {
		super(file);
		this.root = root;
	}

	public WolfMongoProposalParserUtil(String string, DBRoot root) {
		super(string);
		this.root = root;
	}

	@Override
	public DBRoot getDBRoot() {
		return root;
	}

	@Override
	public IDBTable getFirstTable() {
		IDBTable original = super.getFirstTable();
		if (original != null) {
			IDBTable real = root.getTable(original.getParent().getName(),
					original.getName());
			if (real != null) {
				return real;
			}
		}
		return original;
	}

	public IToken[] getAllErrorTokens() {

		return new IToken[0];
	}

	@Override
	public TransactionRequest createTransactionRequest(ConnectionProperties p) {
		MongoTransactionRequest req = null;
		parse();

		switch (getSqlType()) {
		case Find:
			req = new MongoTransactionRequest(
					SQLOperationType.PREPARED_EXECUTE_QUERY, p,
					getSQLStatement(), binds(), getFirstTable());
			req.setQueryUsesedToSearch(getQueryUsesedToSearch());
			req.setReturnFields(getReturnFields());
			req.setOrderBy(getOrderBy());
			break;
		case Insert:
			req = new MongoTransactionRequest(
					SQLOperationType.PREPARED_EXECUTE, p, getSQLStatement(),
					binds(), getFirstTable());
			req.setInsertObject(getInsertObject());
			break;
		case Update:
			req = new MongoTransactionRequest(
					SQLOperationType.PREPARED_EXECUTE, p, getSQLStatement(),
					binds(), getFirstTable());
			req.setQueryUsesedToSearch(getQueryUsesedToSearch());
			req.setUpdateObject(getUpdateObject());
			if (getUpdateObject() != null) {
				req.setUpsert(isUpsert());
				req.setMulti(isMulti());
			}
			break;
		case Delete:
			req = new MongoTransactionRequest(
					SQLOperationType.PREPARED_EXECUTE, p, getSQLStatement(),
					binds(), getFirstTable());
			req.setRemoveMustMatch(getRemoveMustMatch());
			break;
		}
		req.setMongoSqlType(getSqlType());
		return req;
	}

	@Override
	public String getFormattedString(ASTFormatingInfo info) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getSpecialTokenString() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void clearAlias() {
		// TODO Auto-generated method stub

	}

	@Override
	public ASTAssist getASTAssist() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ASTProposalableAssist getASTProposalableAssist() {
		// TODO Auto-generated method stub
		return null;
	}

}
