package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.File;

public abstract class ProposalParserFactory {

	public static ProposalParserFactory createFactory(String driverName) {
		switch (DatabaseType.parse(driverName)) {
		case MONGO:
			return new WolfMongoProposalParserFactory();
		}
		return new WolfProposalParserFactory();
	}

	public abstract IProposalableParserUtil createParserUtil(String statement,
			DBRoot root);

	public abstract IProposalableParserUtil createParserUtil(File file,
			DBRoot root);

	// --------------------------------------------------------------------------

}
