import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.ast.sql.util.ASTAssist;
import hiro.yoshioka.ast.sql.util.ASTProposalableAssist;
import hiro.yoshioka.sql.resource.IDBResource;

public class AssistDeleteTester extends TestAbsAssistTester {

	public void testDel00() {
		read("testDel00.txt");

		fUtil.setRowColumn(new RowColumn(1, 16));
		ASTProposalableAssist assist = fUtil.getASTProposalableAssist();
		System.out.println("----------------------------------------");
		fUtil.dump();
		fUtil.dumpNodes();

		System.out.println("----------------------------------------");
		assertEquals("AVXg^Cv̓e[uH", ASTAssist.ASSIST_TABLE, assist.getType());
		IDBResource[] proposals = assist.proposalDBResources();
		assertTrue("₪ׂ", proposals.length > 0);
		for (int i = 0; i < proposals.length; i++) {
			System.out.println("[" + i + "]"
					+ proposals[i].getNameWithComment() + "/"
					+ proposals[i].getClass());
			// assertEquals("1ڂUłׂ", 'B',
			// proposals[i].getName().charAt(0));
		}
	}

	public void testDel01() {
		read("testDel01.txt");

		fUtil.setRowColumn(new RowColumn(1, 17));
		ASTProposalableAssist assist = fUtil.getASTProposalableAssist();
		System.out.println("----------------------------------------");
		fUtil.dump();
		fUtil.dumpNodes();

		System.out.println("----------------------------------------");
		assertEquals("AVXg^Cv̓e[uH", ASTAssist.ASSIST_TABLE, assist.getType());
		IDBResource[] proposals = assist.proposalDBResources();
		assertTrue("₪ׂ", proposals.length > 0);
		for (int i = 0; i < proposals.length; i++) {
			System.out.println("[" + i + "]"
					+ proposals[i].getNameWithComment() + "/"
					+ proposals[i].getClass());
			assertEquals("1ڂHłׂ", 'H', proposals[i].getName().charAt(0));
		}
	}

	public void testDel02() {
		read("testDel02.txt");

		fUtil.setRowColumn(new RowColumn(1, 14));
		ASTProposalableAssist assist = fUtil.getASTProposalableAssist();
		System.out.println("----------------------------------------");
		fUtil.dump();
		fUtil.dumpNodes();

		System.out.println("----------------------------------------");
		assertEquals("AVXg^Cv̓e[uH", ASTAssist.ASSIST_TABLE, assist.getType());
		IDBResource[] proposals = assist.proposalDBResources();
		assertTrue("₪ׂ", proposals.length > 0);
		for (int i = 0; i < proposals.length; i++) {
			System.out.println("[" + i + "]"
					+ proposals[i].getNameWithComment() + "/"
					+ proposals[i].getClass());
			assertEquals("1ڂTłׂ", 'T', proposals[i].getName().charAt(0));
		}
	}
}