package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.util.ASTEditorTableListHolder;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.List;

public abstract class ASTDefaultDOL extends SimpleNode implements IDML {
  public ASTEditorTableListHolder fTableHolder = new ASTEditorTableListHolder();
  
  public ASTDefaultDOL(int id) {
    super(id);
  }

  public ASTDefaultDOL(AbsSQLParser p, int id) {
    super(p, id);
  }

  public boolean emptyTableList() {
	    return fTableHolder.size() == 0;
	  }
	  
	  public boolean beginTransaction(){
	    return false;
	  }

	public boolean isDML() {
		return false;
	}
	public String infomatin() {
		return null;
	}

	public void addTable(IDBTable table) {
		fTableHolder.addTable(table);
	}

	public void addTableList(List list) {
		fTableHolder.addTableList(list);
	}

	public boolean isDDL() {
		return false;
	}

	public boolean isDOL() {
		return true;
	}

}
