package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IBasicDL;
import hiro.yoshioka.ast.sql.IDDL;
import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.IExplainPlan;
import hiro.yoshioka.ast.sql.ISubQuery;
import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.ast.sql.oracle.util.WolfParserUtil;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ParserUtil {
	static Pattern NO_CR_PATTERN = Pattern.compile(
			"\\s*CREATE\\s+(OR\\s+REPLACE\\s+)?(FUNCTION|PROCEDURE|TRIGGER).*",
			Pattern.CASE_INSENSITIVE);

	protected Log fLogger = LogFactory.getLog(this.getClass());

	protected String fSQL_Statement;

	protected AbsSQLParser fParser;

	protected RowColumn fRowColumn;

	protected BackWord fBackWord;

	protected boolean flg;

	protected boolean doneParse;

	public static String[] TOKEN_IMAGES = StringUtil.EMPTY_STRING_ARRAY;

	public static void main(String[] args) {
		String lines = "-- hogepiyo\r\n select * from dual                                 ";

		WolfParserUtil util = new WolfParserUtil(lines);
		System.out.println(util.startsWithSelect());
	}

	public AbsSimpleNode getRoot() {
		if (fParser.nodeCreated()) {
			return fParser.getRoot();
		}
		return null;
	}

	public BackWord getBackWord() {
		return fBackWord;
	}

	public abstract AbsSimpleNode[] getFoldingNodes();

	public abstract BindInfo[] binds();

	protected void setTokenImages(String[] tokenImage) {
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < tokenImage.length; i++) {
			String image = tokenImage[i];
			image = image.replaceAll("\"", "");
			image = image.replaceAll("\\p{Cntrl}", "");
			image = image.replaceAll("<.*>", "");
			if (image.length() > 0) {
				list.add(image);
			}
		}
		TOKEN_IMAGES = list.toArray(new String[list.size()]);
	}

	public ParserUtil(File file) throws FileNotFoundException {
		this(new java.io.FileInputStream(file));
		BufferedReader in = new BufferedReader(new FileReader(file));

		try {
			StringBuffer buf = new StringBuffer();
			String line;
			for (; (line = in.readLine()) != null;) {
				buf.append(line).append(StringUtil.LINE_SEPARATOR);
			}
			this.fSQL_Statement = buf.toString();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
	}

	public boolean updatableStatement() {
		if (!canDoBatchExecute() && doQuery()) {
			IDML obj = getDML().getDMLObject();
			if (fLogger.isDebugEnabled()) {
				fLogger.debug(obj.getClass().toString());
			}
			if (obj instanceof ISubQuery) {
				return ((ISubQuery) obj).updatableStatement();
			}
		}
		return false;
	}

	public void dumpNodes() {
		AbsSimpleNode node = fParser.getRoot();
		node.dump2(" ");

	}

	public void dumpSQLStatement() {
		StringUtil.dumpWhiteSpace(fSQL_Statement);
	}

	public ParserUtil(String string) {
		fSQL_Statement = string;
		fParser = createParser(new StringReader(string));
		disable_tracing();
	}

	public abstract AbsSQLParser createParser(StringReader reader);

	/**
	 * @param stream
	 */
	public ParserUtil(FileInputStream stream) {
		fParser = createParser(stream);
		disable_tracing();
	}

	public abstract AbsSQLParser createParser(FileInputStream stream);

	public String getSQLStatement() {
		return fSQL_Statement;
	}

	public void enable_tracing() {
		fParser.enable_tracing();
	}

	public void disable_tracing() {
		fParser.disable_tracing();
	}

	public void dump() {
		fParser.getRoot().dump(">>");
	}

	public boolean parse() {
		if (!doneParse) {
			doneParse = true;
			try {
				flg = fParser.parse(null);
				flg = flg && fParser.nodeCreated();
			} catch (Exception e) {
				flg = false;
			} catch (Error e) {
				flg = false;
			}

		}
		fLogger.info("--- Parsing result[" + flg + "] ---");

		return flg;
	}

	public void setRowColumn(RowColumn rowColumn) {
		fRowColumn = rowColumn;
		fBackWord = new BackWord(fSQL_Statement, fRowColumn);
	}

	IBasicDL getASTBasicDL() {
		if (!fParser.nodeCreated()) {
			return null;
		}
		AbsSimpleNode node = (AbsSimpleNode) fParser.getRoot();
		AbsSimpleNode n;
		n = node.getChild(0);
		if (n instanceof IExplainPlan) {
			n = node.getChild(1);
		}
		if (n instanceof IDML) {
			return ((IDML) n).getDMLObject();
		} else if (n instanceof IDDL) {
			n = n.getChild(0);
			if (fLogger.isDebugEnabled()) {
				fLogger.debug("n class " + n.getClass());
			}
			return (IDDL) n;
		} else {
			n = n.getChild(0);
			if (fLogger.isDebugEnabled()) {
				fLogger.debug("n class " + n.getClass());
			}
			return (IBasicDL) n;
		}
	}

	public IBasicDL[] getBasicDLs() {
		if (!doneParse) {
			parse();
		}
		ArrayList<IBasicDL> retList = new ArrayList<IBasicDL>();
		AbsSimpleNode node = (AbsSimpleNode) fParser.getRoot();
		AbsSimpleNode[] n1 = node.getChildren();
		for (int i = 0; i < n1.length; i++) {
			if (n1[i] instanceof IBasicDL) {
				retList.add((IBasicDL) n1[i]);
			}
			AbsSimpleNode[] n2 = n1[i].getChildren();
			for (int j = 0; j < n2.length; j++) {
				if (n2[j] instanceof IBasicDL) {
					retList.add((IBasicDL) n2[j]);
				}
			}
		}

		return retList.toArray(new IBasicDL[retList.size()]);
	}

	public IDML getDML() {
		if (!doneParse) {
			parse();
		}
		IBasicDL n = getASTBasicDL();
		if (n != null && n.isDML()) {
			return (IDML) n;
		}
		return null;
	}

	public IDBTable getFirstTable() {
		IDML obj = getDML();
		if (obj != null) {
			ASTEditorTableListHolder lis = obj.getEditorTableListHolder();
			if (lis.size() > 0) {
				return (IDBTable) lis.list.get(0);
			}
		}
		return null;
	}

	protected boolean matcheClassPattern(List target, String pattern) {
		if (target == null || target.size() == 0) {
			return false;
		}
		StringBuffer buf = new StringBuffer(getClassName(target.get(0)));
		for (int i = 1; i < target.size(); i++) {
			buf.append(" ").append(getClassName(target.get(i)));
		}
		fLogger.info(buf.toString());
		return buf.toString().matches(pattern);
	}

	public String getClassName(Object o) {
		String str = o.getClass().getName();
		return str.substring(str.lastIndexOf('.') + 1);
	}

	/**
	 * @return
	 */
	public Iterator getExpectedTokens() {
		return fParser.getExpectedTokens();
	}

	/**
	 * @return
	 */
	public boolean doQuery() {
		try {
			if (isDML()) {
				return getDML().isSelectStatement();
			}
			if (doneParse && !flg) {
				if (fLogger.isInfoEnabled()) {
					fLogger.info("ParseŝߊȈՉ͂܂ TRIM̏oSELECTH");
				}
				return startsWithSelect();
			}
			return false;
		} catch (Exception e) {
			fLogger.error("ParseŝߊȈՉ͂܂ TRIM̏oSELECTH");
			return startsWithSelect();
		}
	}

	public boolean beginTransaction() {
		IDML dml = getDML();
		if (dml != null && dml.beginTransaction()) {
			if (fLogger.isInfoEnabled()) {
				fLogger.info("gUNVJn");
			}
			return true;
		}
		return false;
	}

	/**
	 * @return
	 */
	public boolean startsWithSelect() {
		String sel = StringUtil.cnvWithoutComment(fSQL_Statement);
		if (sel.toUpperCase().trim().startsWith("SELECT")) {
			return true;
		}
		return false;
	}

	/**
	 * @return
	 */
	public boolean startsWithTrigFncProc() {
		Matcher m = NO_CR_PATTERN.matcher(fSQL_Statement);
		if (m.find()) {
			return true;
		}
		return false;
	}

	/**
	 * @return
	 */
	public boolean canDoBatchExecute() {
		if (!doneParse) {
			parse();
		}
		if (!flg) {
			return false;
		}
		try {
			IBasicDL[] bases = getBasicDLs();
			for (int i = 0; i < bases.length; i++) {
				if (bases[i] instanceof IDML) {
					if (((IDML) bases[i]).isSelectStatement()) {
						return false;
					}
				}
			}
			return bases.length > 1;
		} catch (Exception e) {
		}
		return false;
	}

	public boolean isDML() {
		if (getDML() != null) {
			return true;
		}
		return false;
	}

	/**
	 * c\bh̎dlc
	 * 
	 * @return
	 * @return String[]
	 * @exception
	 * @see ParserUtil
	 * @since 1.0.0
	 */

	public String[] getSQLStatements() {
		String[] ret = getSQLStatement().split(";");
		List list = new ArrayList();
		for (int i = 0; i < ret.length; i++) {
			if (ret[i].trim().length() > 0) {
				list.add(ret[i]);
			}
		}
		return (String[]) list.toArray(new String[list.size()]);
	}

	public String getDMode() {
		IBasicDL n = getASTBasicDL();
		if (n.isDDL()) {
			return "DDL";
		} else if (n.isDML()) {
			return "DML";
		}
		return "DOL";
	}

	/**
	 * @return
	 */
	public int length() {
		return fSQL_Statement.length();
	}

	protected AbsSimpleNode getSimpleNode() {
		try {
			return fParser.getRoot();
		} catch (RuntimeException e) {
		}
		return null;
	}

	public static AbsSimpleNode[] getNodesPaths(AbsSimpleNode node) {
		ArrayList<AbsSimpleNode> retList = new ArrayList<AbsSimpleNode>();
		addParents(node, retList);
		return retList.toArray(new AbsSimpleNode[retList.size()]);
	}

	private static void addParents(AbsSimpleNode node,
			ArrayList<AbsSimpleNode> retList) {
		retList.add(0, node);
		if (node.getParent() != null) {
			addParents(node.getParent(), retList);
		}
	}

	public static AbsSimpleNode[] getErrorNodes(AbsSimpleNode node) {
		ArrayList<AbsSimpleNode> retList = new ArrayList<AbsSimpleNode>();
		searchErrorNodes(node, retList);
		return retList.toArray(new AbsSimpleNode[retList.size()]);
	}

	private static void searchErrorNodes(AbsSimpleNode node,
			ArrayList<AbsSimpleNode> retList) {
		if (node == null) {
			return;
		}
		AbsSimpleNode[] sn = node.getChildren();

		if (node.fInfomation != null && node.fInfomation.hasError()) {
			retList.add(node);
		}
		for (int i = 0; i < sn.length; i++) {
			searchErrorNodes(sn[i], retList);
		}
	}

}