package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class DBResource implements IDBResource, Serializable,
		IPropertySource {
	private static final long serialVersionUID = 9999521409956L;
	protected transient Log fLogger = LogFactory.getLog(this.getClass());

	protected IDBResource _parent;

	protected String name;

	protected String comment;

	protected Map<String, IDBResource> _children = new LinkedHashMap<String, IDBResource>();

	protected int fResouceKind;

	protected Properties fProperties;

	protected boolean valid = true;

	public static transient Image image;

	public DBResource(IDBResource parent) {
		_parent = parent;
	}

	public Properties getProperties() {
		return fProperties;
	}

	public void setProperties(Properties p) {
		fProperties = p;
	}

	public void slimUp() {
		System.out.println(getName() + "// slim up");
		_children.clear();
		if (fProperties != null) {
			fProperties.clear();
		}
	}

	public int childrenNum() {
		return _children.size();
	}

	public boolean hasChildren() {
		return _children.size() > 0;
	}

	public String getName() {
		return name == null ? "" : name;
	}

	public String getNameWithComment() {
		if (getComment().length() > 0) {
			return getName() + " \"" + getComment() + "\"";
		}
		return getName();
	}

	public String getNameWithAsComment() {
		if (getComment().length() > 0) {
			return getName() + " AS \"" + getComment() + "\"";
		}
		return getName();
	}

	public String getUName() {
		return getName().toUpperCase();
	}

	public boolean startsNameWith(String string) {
		return getUName().startsWith(string.toUpperCase());
	}

	public boolean startsCommentWith(String string) {
		return getUComment().startsWith(string.toUpperCase());
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getComment() {
		return comment == null ? StringUtil.EMPTY_STRING : comment;
	}

	public String getUComment() {
		return getComment().toUpperCase();
	}

	public void setComment(String str) {
	}

	public DBRoot getRoot() {
		IDBResource parent = getParent();
		if (parent == null) {
			return null;
		}
		return parent.getRoot();
	}

	public IDBResource getParent() {
		return _parent;
	}

	public String getImageString() {
		return "\u211b";
	}

	public IDBResource[] listArrayResources() {
		List<IDBResource> list = listResources();

		return (IDBResource[]) list.toArray(new IDBResource[list.size()]);
	}

	public List<IDBResource> listResources() {
		ArrayList<IDBResource> list = new ArrayList<IDBResource>();
		list.addAll(_children.values());
		return list;
	}

	protected List listResources(String pattern) {
		ArrayList<DBResource> list = new ArrayList<DBResource>();
		IDBResource[] target = listArrayResources();
		for (int i = 0; i < target.length; i++) {
			DBResource resource = (DBResource) target[i];
			if (resource.containKeyInNameOrComment(pattern)) {
				list.add(resource);
			}
		}
		return list;
	}

	public List<IDBResource> startsWithResourceLists(String pattern) {
		ArrayList<IDBResource> list = new ArrayList<IDBResource>();
		IDBResource[] target = listArrayResources();
		for (int i = 0; i < target.length; i++) {
			IDBResource resource = (IDBResource) target[i];
			if (resource.getUName().startsWith(pattern.toUpperCase())) {
				list.add(resource);
			}
		}
		return list;
	}

	protected boolean containKeyInNameOrComment(String regex) {
		try {
			Pattern p = Pattern.compile(regex, Pattern.CASE_INSENSITIVE);
			Matcher m = p.matcher(getName());
			Matcher m2 = p.matcher(getComment());
			if (m.find() || m2.find()) {
				return true;
			}
		} catch (Exception e) {
		}
		return false;
	}

	public void setResources(Map<String, IDBResource> map) {
		_children = map;
	}

	public IDBResource getResource(String key) {
		return key == null ? null : (IDBResource) _children.get(key
				.toUpperCase());
	}

	public void putResource(String key, IDBResource child) {
		_children.put(key.toUpperCase(), child);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(getClass().getName());
		buf.append(" UNAME[").append(getUName());
		buf.append("] ChildNum:");
		buf.append(_children.size());
		return buf.toString();
	}

	private void readObject(ObjectInputStream in) throws IOException,
			ClassNotFoundException {
		in.defaultReadObject();
		fLogger = LogFactory.getLog(this.getClass());
	}

	public Object getEditableValue() {
		return null;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptor = new IPropertyDescriptor[0];
		if (fProperties == null) {
			return descriptor;
		}
		try {
			descriptor = new IPropertyDescriptor[fProperties.size()];
			int i = 0;
			for (Iterator ite = fProperties.keySet().iterator(); ite.hasNext(); i++) {
				String key = (String) ite.next();
				descriptor[i] = new TextPropertyDescriptor(key, key);
			}
			return descriptor;
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
		return new IPropertyDescriptor[0];
	}

	public Object getPropertyValue(Object id) {
		if (fProperties == null) {
			return StringUtil.EMPTY_STRING;
		}
		return fProperties.getProperty((String) id);
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
	}

	public boolean isValid() {
		return valid;
	}

	public void setValid(boolean valid) {
		this.valid = valid;
	}

	public Image getImage() {
		return image;
	}

	@Override
	public int hashCode() {
		return (getClass().getName() + getName()).hashCode();
	}
}