package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.util.ParserFactory;
import hiro.yoshioka.ast.sql.util.ParserUtil;
import hiro.yoshioka.ast.sql.util.ProposalableParserUtil;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.File;
import java.io.FileNotFoundException;

public class WolfParserFactory extends ParserFactory {
	
	public ParserUtil createParserUtil(String statement){
		return new WolfParserUtil(statement);
	}
	
	public ParserUtil createParserUtil(File file){
		try {
			return new WolfParserUtil(file);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public ProposalableParserUtil createParserUtil(String statement , DBRoot root){
		return new WolfProposalParserUtil(statement,root);
	}
	
	public ProposalableParserUtil createParserUtil(File file , DBRoot root){
		try {
			return new WolfProposalParserUtil(file,root);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}
	
}
