package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.ast.sql.oracle.ASTDefaultDDL;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.util.ASTEditorTableListHolder;

public class TableListFindSQLNodeVisitor extends DefaultSQLNodeVisitor {
	public ASTEditorTableListHolder fASTEditorTableListHolder;
	public boolean forceClipDML;

	public Object doJob(SimpleNode node, Object data) {
		if (node instanceof ASTDefaultDDL && node.contain((RowColumn) data)) {
			if (log.isInfoEnabled()) {
				log.info(node + " instanceof ASTDefaultDDL" + node.getClass()
						+ " TH[" + ((ASTDefaultDDL) node).fTableHolder + "] ");
			}
			v.add(node);
			fASTEditorTableListHolder = ((ASTDefaultDDL) node).fTableHolder;
		}
		if (node instanceof IDML
				&& (node.contain((RowColumn) data) || forceClipDML)) {
			if (log.isInfoEnabled()) {
				log.info(node + " instanceof IDML" + node.getClass() + " TH["
						+ ((IDML) node).getEditorTableListHolder() + "]");
			}
			v.add(node);
			fASTEditorTableListHolder = ((IDML) node)
					.getEditorTableListHolder();
		}
		if (!node.contain((RowColumn) data)) {
			if (node instanceof ASTDefaultDDL || node instanceof IDML) {
				if (log.isInfoEnabled()) {
					log.info("ꂠ" + node);
				}
			}
		}
		SimpleNode n;
		for (int ord = 0; ord < node.jjtGetNumChildren(); ord++) {
			n = (SimpleNode) node.jjtGetChild(ord);

			n.jjtAccept(this, data);
		}
		return v;
	}

}