package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

public class DBSchema extends DBResource implements IDBSchema {
	private static final long serialVersionUID = 9999204848887L;
	protected Map<String, IDBTrigger> fTriggerMap = new LinkedHashMap<String, IDBTrigger>();
	protected Map<String, IDBSequence> fSequenceMap = new LinkedHashMap<String, IDBSequence>();

	public DBSchema(DBRoot root) {
		super(root);
	}

	public void putTable(IDBTable table) {
		putResource("TABLE#" + table.getName(), table);
	}

	public void putProcedure(IDBTable table) {
		putResource("PROCEDURE#" + table.getName(), table);
	}

	public String[] getTableNames() {
		ArrayList list = new ArrayList();
		List resources = listResources();
		for (Iterator ite = resources.iterator(); ite.hasNext();) {
			IDBTable t = (IDBTable) ite.next();
			if (!t.isProcudeure()) {
				list.add(t.getName());
			}
		}
		return (String[]) list.toArray(new String[list.size()]);
	}

	public IDBTrigger getTrigger(String name) {
		return fTriggerMap.get(name);
	}

	public IDBTrigger[] getTriggers() {
		return fTriggerMap.values().toArray(new IDBTrigger[0]);
	}

	public void putTrigger(IDBTrigger trigger) {
		fTriggerMap.put(trigger.getName(), trigger);
	}

	public IDBSequence getSequence(String name) {
		return fSequenceMap.get(name);
	}

	public IDBSequence[] getSequences() {
		return fSequenceMap.values().toArray(new IDBSequence[0]);
	}

	public void putSequence(IDBSequence sequence) {
		fSequenceMap.put(sequence.getName(), sequence);
	}

	public IDBTable[] getTables() {
		ArrayList list = new ArrayList();
		for (Iterator ite = _children.values().iterator(); ite.hasNext();) {
			IDBTable t = (IDBTable) ite.next();
			if (t.isTable() || t.isView()) {
				list.add(t);
			}
		}
		return (IDBTable[]) list.toArray(new IDBTable[list.size()]);
	}

	public IDBTable[] getProcedures() {
		ArrayList list = new ArrayList();
		List resources = listResources();
		for (Iterator ite = _children.values().iterator(); ite.hasNext();) {
			IDBTable t = (IDBTable) ite.next();
			if (t.isProcudeure()) {
				list.add(t);
			}
		}
		return (IDBTable[]) list.toArray(new IDBTable[list.size()]);
	}

	public IDBTable[] getFunctions() {
		ArrayList list = new ArrayList();
		List resources = listResources();
		for (Iterator ite = _children.values().iterator(); ite.hasNext();) {
			IDBTable t = (IDBTable) ite.next();
			if (t.isFunction()) {
				list.add(t);
			}
		}
		return (IDBTable[]) list.toArray(new IDBTable[list.size()]);
	}

	public boolean contain(String pattern) {
		if (containKeyInNameOrComment(pattern)) {
			return true;
		}
		for (Iterator ite = _children.values().iterator(); ite.hasNext();) {
			if (((IDBTable) ite.next()).contain(pattern)) {
				return true;
			}
		}
		IDBTrigger[] lis = getTriggers();
		for (int i = 0; i < lis.length; i++) {
			if (lis[i].contain(pattern)) {
				return true;
			}
		}

		return false;
	}

	public List listResources() {
		List list = super.listResources();
		if (fTriggerMap.size() > 0) {
			list.addAll(fTriggerMap.values());
		}
		if (fSequenceMap.size() > 0) {
			list.addAll(fSequenceMap.values());
		}
		return list;
	}

	/**
	 * e[uDŒT܂B <BR>
	 * 
	 * @see hiro.yoshioka.sql.resource.IDBResource#getResource(java.lang.Object)
	 */
	public IDBResource getResource(Object name) {
		IDBResource ret = getTable((String) name);
		if (ret == null) {
			return getProcedure((String) name);
		}
		return ret;
	}

	public IDBTable getTable(String name) {
		return getTable(name, false);
	}

	public IDBTable getTable(String name, boolean deep) {
		IDBResource ret = super.getResource("TABLE#" + name);
		if (ret == null && deep) {
			for (Iterator ite = _children.values().iterator(); ite.hasNext();) {
				IDBTable t = (IDBTable) ite.next();
				if (t.isTable() && t.getName().equalsIgnoreCase(name)) {
					ret = t;
				}
			}
		}
		return (IDBTable) ret;
	}

	public IDBTable getProcedure(String name) {
		return (IDBTable) super.getResource("PROCEDURE#" + name);
	}

	@Override
	public void slimUp() {
		fTriggerMap.clear();
		fSequenceMap.clear();
		for (Iterator ite = _children.values().iterator(); ite.hasNext();) {
			IDBTable t = (IDBTable) ite.next();
			if (t.isProcudeure() || t.isFunction()) {
				_children.remove(t);
			} else {
				t.slimUp();
			}
		}
	}

	public List getResourceListStartsWith(String tableNameString) {
		ArrayList list = new ArrayList();
		for (Iterator ite = _children.entrySet().iterator(); ite.hasNext();) {
			Map.Entry entry = (Entry) ite.next();
			IDBTable t = (IDBTable) entry.getValue();
			if (t.startsNameWith(tableNameString)) {
				list.add(t);
			}
		}
		return list;
	}

	public String getCurrentDefaultString() {
		if (isDefault()) {
			if (isCurrent()) {
				return "\u24b9\u24b8";
			} else {
				return "\u24b9";
			}
		} else {
			if (isCurrent()) {
				return "\u24b8";
			} else {
				return StringUtil.EMPTY_STRING;
			}
		}
	}

	public boolean isDefault() {
		DBRoot root = getRoot();
		if (root == null) {
			return false;
		}
		return this.equals(root.getDefaultSchema());
	}

	public boolean isCurrent() {
		DBRoot root = getRoot();
		if (root == null) {
			return false;
		}
		return this.equals(root.getCurrentSchema());
	}

	public String toString() {
		return getNameWithComment();
	}
}