import hiro.yoshioka.ast.sql.oracle.util.WolfParserFactory;
import hiro.yoshioka.ast.sql.util.DBResourceUtil;
import hiro.yoshioka.ast.sql.util.ParserFactory;
import hiro.yoshioka.ast.sql.util.ProposalableParserUtil;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;

import junit.framework.TestCase;

public class TestAbsAssistTester extends TestCase {
	ProposalableParserUtil fUtil;

	String fSQL_Statement;

	protected void tearDown() throws Exception {
		fUtil = null;
		System.gc();
	}

	protected void read(File file) {
		try {
			// ParserFactory f = new MyParserFactory();
			ParserFactory f = new WolfParserFactory();

			// fUtil = f.createParserUtil(file, AbsBasicSQL.loadDBRoot(new File(
			// "-1764676659")));

			fUtil.enable_tracing();
			if (!fUtil.parse()) {
				for (Iterator ite = fUtil.getExpectedTokens(); ite.hasNext();) {
					System.out.println("kitai[" + ite.next() + "]");
				}
			}
			// fUtil.dumpSQLStatement();
			// fUtil.dumpNodes();
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	protected void read(String file) {
		try {
			File f = new java.io.File("test/input/" + file);
			setStringFromFile(f);

			// ParserFactory ff = new MyParserFactory();
			ParserFactory ff = new WolfParserFactory();

			// DBRoot root = DBResourceUtil.loadDBRoot(new File(
			// "D:/eclipse/serialized/261801626"));
			DBRoot root = MockGenerator.generateDBRoot();
			fUtil = ff.createParserUtil(fSQL_Statement, root);
			// fUtil = ff.createParserUtil(fSQL_Statement, null);

			fSQL_Statement = fUtil.getSQLStatement();
			// fUtil.enable_tracing();
			if (!fUtil.parse()) {
				for (Iterator ite = fUtil.getExpectedTokens(); ite.hasNext();) {
					System.out.println("kitai[" + ite.next() + "]");
				}
			}
			// fUtil.dumpSQLStatement();
			// fUtil.dumpNodes();
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	protected void setStringFromFile(File file) throws FileNotFoundException {
		BufferedReader in = new BufferedReader(new FileReader(file));

		try {
			StringBuffer buf = new StringBuffer();
			String line;
			for (int size; (line = in.readLine()) != null;) {
				buf.append(line).append("\r\n");
			}
			fSQL_Statement = buf.toString();
			fSQL_Statement = fSQL_Statement.replace('\t', ' ');
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
	}

	protected void checkkey(String[] exp, String[] real) {
		for (int i = 0; i < exp.length; i++) {
			boolean find = false;
			for (int j = 0; j < real.length; j++) {
				if (exp[i].equals(real[j].trim())) {
					find = true;
					break;
				}
			}
			if (!find) {
				for (int j = 0; j < real.length; j++) {
					System.out.println(real[j]);
				}
				fail("L[[h񖳂" + exp[i]);
			}
		}
	}

}