package hiro.yoshioka.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class Util {

	private static Clipboard clipboard;

	protected static InputStream getStream(URL url) {
		try {
			return new BufferedInputStream(url.openStream());
		} catch (IOException e) {
			return null;
		}
	}

	/**
	 * @param size
	 * @return
	 */
	private static ImageData resizeImage(ImageData imageData, int size) {
		int w = size;
		int h = size;
		if (imageData.height > imageData.width) {
			double div = (double) imageData.height / size;
			w = (int) (imageData.width / div);
			if (w <= 0) {
				w = 1;
			}
		} else {
			double div = (double) imageData.width / size;
			h = (int) (imageData.height / div);
			if (h <= 0) {
				h = 1;
			}
		}
		return imageData.scaledTo(w, h);
	}

	public static Clipboard getClipboard() {
		if (clipboard == null) {
			clipboard = new Clipboard(Display.getCurrent());
		}

		return clipboard;
	}

	public static boolean matchCanNull(String str1, String str2) {
		if (str1 == null) {
			if (str2 == null) {
				return true;
			}
			return false;
		}
		return str1.equals(str2);
	}

}