package hiro.yoshioka.util;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
	public static final String EMPTY_STRING = "";
	public static final String[] EMPTY_STRING_ARRAY = new String[0];
	public static final Pattern P_SEMICORON_WHITE = Pattern
			.compile(";\\p{Space}");
	public static final Pattern P_SQL_COMMENT = Pattern.compile(
			"(--(.*)|/[*][^*]*?[*]/)", Pattern.MULTILINE);

	static Pattern P = Pattern.compile("(['][^']*?['])|([ ]+)");

	public static final String LINE_SEPARATOR;
	static {
		LINE_SEPARATOR = System.getProperties().getProperty("line.separator");
	}

	public static void append(StringBuilder buf, String text) {
		buf.append(text);
	}

	public static void appendln(StringBuilder buf, String text) {
		appendln(buf, 0, text);
	}

	public static void appendln(StringBuilder buf, int depth, String text) {
		if (depth > 0) {
			for (int i = 0; i < depth; i++) {
				buf.append("  ");
			}
		}
		buf.append(text).append(LINE_SEPARATOR);
	}

	public static boolean isIgnoreCaseStartsWith(String left, String right) {
		return nvl(left).toUpperCase().startsWith(nvl(right).toUpperCase());
	}

	public static int parseIntNoneException(String num) {
		return parseIntNoneException(num, 0);
	}

	public static int parseIntNoneException(String num, int defaultNum) {
		if (num == null) {
			return defaultNum;
		}
		try {
			return Integer.parseInt(num);
		} catch (Exception e) {
			return defaultNum;
		}
	}

	/**
	 * SQLo͗pɎ̒us ' -> '' \ -> \\
	 * 
	 * @param input
	 *            uΏۂ̕
	 * @return u̕
	 */
	static public String cnv2SQLEscape(String input) {
		input = input.replaceAll("'", "''");
		input = input.replaceAll("\\\\", "\\\\\\\\");
		return input;
	}

	/**
	 * DUMP WITH WHITESPACE
	 */
	public static void dumpWhiteSpace(String target) {
		if (isEmpty(target)) {
			return;
		}
		int index = 0;
		int lineIndex = 0;
		DecimalFormat df = new DecimalFormat("00000");
		System.out.println("     \t1\t2\t3\t4\t5\t6\t7\t8\t9\t0");
		out: while (true) {
			System.out.print(df.format(lineIndex * 10) + "\t");
			for (int i = 0; i < 10; i++) {
				if (index >= target.length()) {
					break out;
				}
				char c = (char) target.charAt(index++);
				if (Character.isISOControl(c) || Character.isWhitespace(c)) {
					if (c == '\t') {
						System.out.print("TB");
					} else if (c == ' ') {
						System.out.print("SP");
					} else if (c == '@') {
						System.out.print("ZP");
					} else if (c == '\r') {
						System.out.print("CR");
					} else if (c == '\n') {
						System.out.print("LF");
					} else {
						System.out.print("*");
						System.out.println("char=[" + c + "] type= "
								+ Character.getType(c));
					}
				} else {
					System.out.print(String.valueOf(c));
				}

				System.out.print("\t");
			}
			lineIndex++;
			System.out.println();
		}
		System.out.println();
	}

	public static String cnvWithoutComment(String target) {
		Matcher m = P_SQL_COMMENT.matcher(target);
		return m.replaceAll("");
	}

	public static String continuingBlank2aBlank(String target) {
		Matcher m = P.matcher(target);
		StringBuffer rel = new StringBuffer();

		while (m.find()) {
			if (m.group(2) == null) {
				// rel.append(m.group(1));
			} else {
				m.appendReplacement(rel, " ");
			}
		}
		m.appendTail(rel);
		return rel.toString();
	}

	public static String nvl(Object string) {
		return string == null ? EMPTY_STRING : string.toString();
	}

	public static boolean isEmpty(Object o) {
		if (o == null) {
			return true;
		}
		if (o.toString().trim().length() == 0) {
			return true;
		}
		return false;
	}

	public static String resetCRLF(String target, boolean many2oneCrLl) {
		String t = target.replaceAll("\r\n", "\n");
		t = t.replaceAll("\r", "\n");
		if (many2oneCrLl) {
			t = t.replaceAll("[\n]+", "\n");
		}
		return t.replaceAll("\n", LINE_SEPARATOR);
	}

	public static String getStackTraceString(Throwable e) {
		StringBuilder buf = new StringBuilder();
		StackTraceElement[] elm = e.getStackTrace();
		buf.append(e.getMessage());
		for (int i = 0; i < elm.length; i++) {
			buf.append(elm[i] + LINE_SEPARATOR);
		}
		return resetCRLF(buf.toString(), true);
	}

	public static String escName(String str) {
		// u<vu&lt;v
		// u&vu&amp;v
		// u>vu&gt;v
		// u"vu&quot;v
		// u'vu&apos;v
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			switch (c) {
			case '(':
			case 'i':
				buf.append("_");
				break;
			case ')':
			case 'j':
				break;
			case '%':
				break;
			case '':
				break;
			case '<':
				buf.append("&lt;");
				break;
			case '&':
				buf.append("&amp;");
				break;
			case '>':
				buf.append("&gt;");
				break;
			case '"':
				buf.append("&quot;");
				break;
			case '\'':
				buf.append("&apos;");
				break;

			default:
				buf.append(c);
				break;
			}
		}
		return buf.toString();
	}

	public static String esc(String str) {
		// u<vu&lt;v
		// u&vu&amp;v
		// u>vu&gt;v
		// u"vu&quot;v
		// u'vu&apos;v
		StringBuilder buf = new StringBuilder();
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			switch (c) {
			case '<':
				buf.append("&lt;");
				break;
			case '&':
				buf.append("&amp;");
				break;
			case '>':
				buf.append("&gt;");
				break;
			case '"':
				buf.append("&quot;");
				break;
			case '\'':
				buf.append("&apos;");
				break;

			default:
				buf.append(c);
				break;
			}
		}
		return buf.toString();
	}

	/**
	 * @param text
	 * @return
	 */
	public static String getThisLineSeparator(String text) {
		if (text.indexOf("\r\n") > 0) {
			return "\r\n";
		} else if (text.indexOf("\r") > 0) {
			return "\r";
		} else if (text.indexOf("\n") > 0) {
			return "\n";
		}
		return LINE_SEPARATOR;
	}
}