package hiro.yoshioka.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {

	private Class location;

	private String name;

	public FileUtil(Class clazz, String filename) {
		this.location = clazz;
		this.name = filename;
	}

	public static void main(String[] arg) {
		deleteEmptyFolder(new File("C:/Users/Yonsama/Documents/nuki"));
	}

	public static String[] getTexts(File f) {
		BufferedReader in = null;

		List<String> retList = new ArrayList<String>();
		try {
			in = new BufferedReader(new FileReader(f));
			String line;

			while ((line = in.readLine()) != null) {
				retList.add(line);
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return (String[]) retList.toArray(new String[retList.size()]);
	}

	public static String getText(File f) {
		BufferedReader in = null;
		StringBuffer buf = new StringBuffer();
		try {
			in = new BufferedReader(new FileReader(f));
			String line;

			while ((line = in.readLine()) != null) {
				buf.append(line).append(StringUtil.LINE_SEPARATOR);
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return buf.toString();
	}

	public static void deleteEmptyFolder(File dir) {
		if (dir.isDirectory()) {
			File[] children = dir.listFiles();
			if (children.length > 0) {
				for (int i = 0; i < children.length; i++) {
					if (children[i].isFile() && children[i].length() == 0) {
						children[i].delete();
					} else if (children[i].isDirectory()) {
						deleteEmptyFolder(children[i]);
					}
				}
			} else {
				dir.delete();
			}
		}
	}

	public BufferedInputStream getStream() {
		InputStream is = null;

		if (location != null) {
			is = location.getResourceAsStream(name);

		} else {
			try {
				is = new FileInputStream(name);
			} catch (FileNotFoundException e) {
				return null;
			}
		}
		if (is == null) {
			return null;
		} else {
			return new BufferedInputStream(is);
		}
	}

}
