package hiro.yoshioka.sdh;

import java.util.ArrayList;

import hiro.yoshioka.sdh.pair.DifferenceStringData;
import hiro.yoshioka.sdh.pair.FlashStringData;
import hiro.yoshioka.sdh.pair.MarkStringData;
import hiro.yoshioka.util.Differencer;
import hiro.yoshioka.util.StringUtil;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class RDHTableLabelProvider extends ColumnLabelProvider {
	RDHTableViewer v;
	int colIdx;
	final boolean supportDiff;
	int[] percentIdx;
	private OptimizedIndexSearcher searcher = new OptimizedIndexSearcher();
	public static Color NULL_COLOR;
	public static Color SIMA_COLOR;

	public RDHTableLabelProvider(RDHTableViewer view, int colIdx) {
		this.v = view;
		this.supportDiff = v.supportDiff();
		this.colIdx = colIdx;
	}

	@Override
	public String getText(Object element) {
		StringRecordData[] datum = (StringRecordData[]) element;
		if (datum[colIdx].getPair() instanceof FlashStringData) {

		} else if (datum[colIdx].getPair() instanceof MarkStringData) {
			MarkStringData mark = (MarkStringData) datum[colIdx].getPair();
			if (colIdx > 0) {
				switch (mark.getMark()) {
				case UP:
					if (StringUtil.isEmpty(mark.getNote())) {
						return " " + datum[colIdx].getString();
					}
					return datum[colIdx].getString() + " { " + mark.getNote()
							+ "}";
				case DOWN:
					if (StringUtil.isEmpty(mark.getNote())) {
						return " " + datum[colIdx].getString();
					}
					return datum[colIdx].getString() + " { " + mark.getNote()
							+ "}";
				}
				return datum[colIdx].getString();
			}
		} else if (supportDiff
				&& datum[colIdx].getPair() instanceof DifferenceStringData) {
			DifferenceStringData d = (DifferenceStringData) datum[colIdx]
					.getPair();
			switch (d.fDifferenceKind) {
			case Differencer.ADDITION:
				if (colIdx == 0) {
					return datum[colIdx].getString() + "[+]";
				}
				return datum[colIdx].getString();
			case Differencer.CHANGE:
				return datum[colIdx].getString() + d;
			}
		}
		String str = datum[colIdx].getString();
		if (str.length() == 0) {
			return "<NULL>";
		}
		return str;
	}

	boolean even = true;
	Color c;

	@Override
	public Color getForeground(Object element) {
		StringRecordData[] datum = (StringRecordData[]) element;
		if (datum[colIdx].getPair() instanceof MarkStringData) {
			MarkStringData mark = (MarkStringData) datum[colIdx].getPair();
			switch (mark.getMark()) {
			case UP:
				return v.getTable().getDisplay().getSystemColor(SWT.COLOR_RED);
			case DOWN:
				return v.getTable().getDisplay().getSystemColor(SWT.COLOR_BLUE);
			}
		}
		return super.getForeground(element);
	}

	public Color getBackground(Object element) {
		return c;
	}

	public void update(ViewerCell cell) {
		boolean normal = true;
		TableItem item = (TableItem) cell.getItem();
		StringRecordData[] items = (StringRecordData[]) item.getData();
		if (supportDiff && (items[colIdx].getPair() != null)
				&& (items[colIdx].getPair() instanceof DifferenceStringData)) {
			DifferenceStringData d = (DifferenceStringData) items[colIdx]
					.getPair();
			switch (d.fDifferenceKind) {
			case Differencer.ADDITION:
				c = v.getTable().getDisplay().getSystemColor(SWT.COLOR_MAGENTA);
				normal = false;
				break;
			case Differencer.CHANGE:
				normal = false;
				c = v.getTable().getDisplay().getSystemColor(SWT.COLOR_RED);
				break;
			case Differencer.DELETION:
				normal = false;
				c = v.getTable().getDisplay().getSystemColor(SWT.COLOR_GRAY);
				break;
			}
		}
		if (normal) {
			String str = items[colIdx].getString();
			if (str.length() == 0) {
				if (NULL_COLOR == null) {
					c = v.getTable().getDisplay().getSystemColor(
							SWT.COLOR_GREEN);
				} else {
					c = NULL_COLOR;
				}
			} else if (str.startsWith("<") && str.endsWith(">")) {
				c = v.getTable().getDisplay().getSystemColor(SWT.COLOR_GRAY);
			} else if (searcher.isEven(item)) {
				c = null;
			} else {
				if (SIMA_COLOR == null) {
					c = v.getTable().getDisplay().getSystemColor(
							SWT.COLOR_YELLOW);
				} else {
					c = SIMA_COLOR;
				}
			}
		}

		super.update(cell);
	}

	private class OptimizedIndexSearcher {
		private int lastIndex = 0;

		public boolean isEven(TableItem item) {
			TableItem[] items = item.getParent().getItems();

			// 1. Search the next ten items
			for (int i = lastIndex; i < items.length && lastIndex + 10 > i; i++) {
				if (items[i] == item) {
					lastIndex = i;
					return lastIndex % 2 == 0;
				}
			}

			// 2. Search the previous ten items
			for (int i = lastIndex; i < items.length && lastIndex - 10 > i; i--) {
				if (items[i] == item) {
					lastIndex = i;
					return lastIndex % 2 == 0;
				}
			}

			// 3. Start from the beginning
			for (int i = 0; i < items.length; i++) {
				if (items[i] == item) {
					lastIndex = i;
					return lastIndex % 2 == 0;
				}
			}

			return false;
		}
	}

}