package hiro.yoshioka.sdh;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultHyperLinkAction implements IRDHHyperLinkAction {
	protected Log log = LogFactory.getLog(this.getClass());
	int[] linkIdx;
	Set<Integer> LinkSet = new HashSet<Integer>();

	public DefaultHyperLinkAction(int[] linkIdx) {
		this.linkIdx = linkIdx;
		for (int i = 0; i < linkIdx.length; i++) {
			LinkSet.add(new Integer(linkIdx[i]));
		}
	}

	public void activateHyperLink(ResultSetDataHolder rdh, int colIdx, int row) {
		if (log.isInfoEnabled()) {
			log.info("clicked[" + row + "/" + colIdx + ":"
					+ rdh.getStringRecordRow(row)[colIdx].fString);
		}
	}

	public int[] getHyperLinkIndex() {
		return linkIdx;
	}

	public boolean isHyperLinkColumn(int colIdx) {
		return LinkSet.contains(new Integer(colIdx));
	}

}
