package hiro.yoshioka.sdh;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColumnShiftTester {

	public static void main(String[] args) {
		Display display = new Display();

		Shell shell = new Shell(display);
		shell.setLayout(new GridLayout(2, false));

		final RDHTableViewer v = new RDHTableViewer(shell);
		v.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		// v.setInputAdjustDatum(createModel());

		final String[] columnDatum = new String[400];
		for (int i = 0; i < 400; i++) {
			columnDatum[i] = (i % 7) + "";
		}

		Composite btnPanel = new Composite(shell, SWT.BOTTOM);
		btnPanel.setLayout(new FillLayout(SWT.VERTICAL));
		Button cpBtn = new Button(btnPanel, SWT.BORDER);

		cpBtn.setText("copy");
		cpBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				System.out
						.println("pushed cpBtn-------------------------------");
				ResultSetDataHolder rdh = v.getRDH();
				rdh.addColumn("ima", columnDatum);
				v.setInputAdjustDatum(rdh);
			}
		});

		System.out.println("aaaaaaaa");
		shell.open();
		System.out.println("aaaaaaaabbbbbbbbbbb");

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		System.out.println("aaaaaaaabbbbbbbbbbbddddddddddd");

		display.dispose();

	}

	private static ResultSetDataHolder createModel() {
		ResultSetDataHolder rdh = new ResultSetDataHolder(new String[] {
				"name", "job", "email", "use(%)" });
		for (int i = 0; i < 100; i++) {
			rdh.addRow(new String[] { i + "", "Bokowski",
					"Boris_Bokowski@ca.ibm.com", i + "" });
			rdh.addRow(new String[] { i + "", "Creasey",
					"Tod_Creasey@ca.ibm.com", i % 42 + "" });
			rdh.addRow(new String[] { i + "", "Beaton", "wayne@eclipse.org",
					i % 23 + "" });
			rdh.addRow(new String[] {
					"i     am \n a\n one\n of \n pen\n this is a pen too.",
					"Schi\r\nn\r\nsdl", "tom.schindl@bestsolution.at", "100" });
		}
		// rdh.addRow(new String[] { "Boris", "Bokowski",
		// "Boris_Bokowski@ca.ibm.com" });
		// rdh.addRow(new String[] { "Tod", "Creasey", "Tod_Creasey@ca.ibm.com"
		// });

		return rdh;
	}
}
