package hiro.yoshioka.chart;

import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Composite;
import org.jfree.experimental.chart.swt.ChartComposite;

public class TimeChartInfo extends ChartInfo {
	public static final int MODE_TIME = -1;
	public static final int MODE_DAY = 0;
	public static final int MODE_MONTH = 1;
	public static final int MODE_YEAR = 2;
	public int dateIndex;
	public int[] valueIndexes;
	public int mode = MODE_DAY;
	public boolean simple = false;

	public ChartComposite createChartComposite(Composite parent) {
		return RDHTimeSeriesUtil.createChartComposite(parent, this);
	}

	private static int parseMode(String mode) {
		if ("MODE_TIME".equalsIgnoreCase(mode)) {
			return MODE_TIME;
		} else if ("MODE_DAY".equalsIgnoreCase(mode)) {
			return MODE_DAY;
		} else if ("MODE_MONTH".equalsIgnoreCase(mode)) {
			return MODE_MONTH;
		} else if ("MODE_YEAR".equalsIgnoreCase(mode)) {
			return MODE_YEAR;
		}
		return MODE_DAY;
	}

	public TimeChartInfo(String[] params) {
		super(params[0], null);
		String[] nParams = new String[params.length - 1];
		for (int i = 1; i < params.length; i++) {
			nParams[i - 1] = params[i];
		}
		setParams(nParams);
	}

	private void setParams(String[] params) {
		for (int i = 0; i < params.length; i++) {
			switch (i) {
			case 0:
				this.dateIndex = parseInt(params[i]);
				break;
			case 1:
				String[] vs = params[i].split(",");
				ArrayList<Integer> list = new ArrayList<Integer>();
				for (int j = 0; j < vs.length; j++) {
					try {
						list.add(new Integer(vs[j].trim()));
					} catch (NumberFormatException e) {
					}
				}
				this.valueIndexes = new int[list.size()];
				for (int j = 0; j < list.size(); j++) {
					this.valueIndexes[j] = list.get(j);
				}
				break;
			case 2:
				this.mode = parseMode(params[i].trim());
				break;
			}
		}
	}

	public TimeChartInfo(String title, ResultSetDataHolder rdh, String[] params) {
		super(title, rdh);
		setParams(params);
	}

	public TimeChartInfo(String title, ResultSetDataHolder rdh) {
		super(title, rdh);
	}

	@Override
	public String toString() {
		String val = "";
		for (int i = 0; valueIndexes != null && i < valueIndexes.length; i++) {
			if (i > 0) {
				val += ",";
			}
			val += valueIndexes[i];
		}
		return "TimeChartInfoy" + super.toString() + " dateIndex:" + dateIndex
				+ " valueIndexes:" + val + "z";
	}
}
