package hiro.yoshioka.chart;

import hiro.yoshioka.sdh.ResultSetDataHolder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.jfree.experimental.chart.swt.ChartComposite;

public abstract class ChartInfo {
	protected final Log log = LogFactory.getLog(getClass());

	public ChartInfo(String title, ResultSetDataHolder rdh) {
		this.title = title;
		this.rdh = rdh;
	}

	public abstract ChartComposite createChartComposite(Composite parent);

	public String title;
	public ResultSetDataHolder rdh;

	protected int parseInt(String number) {
		return Integer.parseInt(number.trim());
	}

	@Override
	public String toString() {
		return "TITLE:" + title;
	}

}
