/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    mod2midi.h

    Header file for sample info -> MIDI event conversion

 */
#ifndef ___MOD2MIDI_H_
#define ___MOD2MIDI_H_

#include "unimod.h"


/**** private definitions ****/
typedef struct _ModVoice
  {
    int sample;			/* current sample ID */
    int noteon;			/* (-1 means OFF status) */
    int time;			/* time when note was activated */
    int period;			/* current frequency */
    int wheel;			/* current pitch wheel value */
    int pan;			/* current panning */
    int vol;			/* current volume */

    int32 noteson[4];		/* bit map for notes 0-127 */
  }
ModVoice;

struct s_mod2midi_ex_t {
	
void (*Voice_SetVolume)(tmdy_struct_ex_t* tmdy_struct, UBYTE, UWORD);
void (*Voice_SetFrequency)(tmdy_struct_ex_t* tmdy_struct, UBYTE, ULONG);
void (*Voice_SetPanning)(tmdy_struct_ex_t* tmdy_struct, UBYTE, ULONG);
void (*Voice_Play)(tmdy_struct_ex_t* tmdy_struct, UBYTE, SAMPLE *, ULONG);
void (*Voice_Stop)(tmdy_struct_ex_t* tmdy_struct, UBYTE);
BOOL (*Voice_Stopped)(tmdy_struct_ex_t* tmdy_struct, UBYTE);
void (*Voice_NewTempo)(tmdy_struct_ex_t* tmdy_struct, UWORD, UWORD);
void (*Voice_TickDone)(tmdy_struct_ex_t* tmdy_struct);
void (*Voice_StartPlaying)(tmdy_struct_ex_t* tmdy_struct);
void (*Voice_EndPlaying)(tmdy_struct_ex_t* tmdy_struct);
void (*load_module_samples)(tmdy_struct_ex_t* tmdy_struct, SAMPLE *, int, int);
void (*Voice_SetPeriod)(tmdy_struct_ex_t* tmdy_struct, UBYTE v, ULONG period);

/**** private variables ****/
ModVoice ModV[MOD_NUM_VOICES];
int at;

};


mod2midi_ex_t* new_mod2midi(tmdy_struct_ex_t *tmdy_struct);
void destroy_mod2midi(mod2midi_ex_t* mod2midi);
#endif  /* ___MOD2MIDI_H_ */

