
/* interfaces */

static int aq_calc_fragsize(tmdy_struct_ex_t *tmdy_struct);
/* aq_calc_fragsize() calculates the best fragment size for audio device.
 */

static void aq_setup(tmdy_struct_ex_t *tmdy_struct);
/* aq_setup() allocates the buffer for software queue, and estimate
 * maxmum queue size of audio device.
 */

static void aq_set_soft_queue(tmdy_struct_ex_t *tmdy_struct, double soft_buff_time, double fill_start_time);
/* aq_set_soft_queue() makes software audio queue.
 * If fill_start_time is positive, TiMidity doesn't start playing immidiately
 * until the autio buffer is filled.
 */

static int aq_add(tmdy_struct_ex_t *tmdy_struct, int32 *samples, int32 count);
/* aq_add() adds new samples to software queue.  If samples is NULL,
 * aq_add() only updates internal software queue buffer.
 */

static int32 aq_samples(tmdy_struct_ex_t *tmdy_struct);
/* aq_samples() returns number of samples which is really played out.
 */

static int32 aq_filled(tmdy_struct_ex_t *tmdy_struct);
static int32 aq_soft_filled(tmdy_struct_ex_t *tmdy_struct);
/* aq_filled() returns filled queue length of audio device.
 * aq_soft_filled() returns filled queue length of software buffer.
 */

static int32 aq_fillable(tmdy_struct_ex_t *tmdy_struct);
/* aq_fillable() returns fillable queue length of qudio device. */

static int aq_flush(tmdy_struct_ex_t *tmdy_struct, int discard);
/* If discard is true, aq_flush() discards all audio queue and returns
 * immediately, otherwise aq_flush() waits until play all out.
 * aq_flush() returns RC_* message.
 */

static int aq_soft_flush(tmdy_struct_ex_t *tmdy_struct);
/* aq_soft_flush() transfers all buffer to device */

static int aq_fill_nonblocking(tmdy_struct_ex_t *tmdy_struct);
/* aq_fill_nonblocking() transfers software audio buffer to device.
 * This function doesn't block if (play_mode->flag&PF_CAN_TRACE) is true.
 */

static double aq_filled_ratio(tmdy_struct_ex_t *tmdy_struct);
/* aq_filled_ratio() returns filled ratio for audio device queue. */

static int aq_get_dev_queuesize(tmdy_struct_ex_t *tmdy_struct);
/* aq_get_dev_queuesize() returns device audio queue length
 */
/*
static int aq_fill_buffer_flag;
* non-zero if aq_add() is in filling mode *
*/

/* effect.c */
extern void init_effect(tmdy_struct_ex_t *tmdy_struct);
extern void do_effect(tmdy_struct_ex_t *tmdy_struct, int32* buf, int32 count);


/** local functions **/
static void alloc_soft_queue(tmdy_struct_ex_t *tmdy_struct);
static int add_play_bucket(tmdy_struct_ex_t *tmdy_struct,const char *buf, int n);
static void reuse_audio_bucket(tmdy_struct_ex_t *tmdy_struct,AudioBucket *bucket);
static AudioBucket *next_allocated_bucket(tmdy_struct_ex_t *tmdy_struct);
static void flush_buckets(tmdy_struct_ex_t *tmdy_struct);
static int aq_fill_one(tmdy_struct_ex_t *tmdy_struct);
static void aq_wait_ticks(tmdy_struct_ex_t *tmdy_struct);
static int32 estimate_queue_size(tmdy_struct_ex_t *tmdy_struct);

