#ifndef _TIMIDITY_STRUCT_H
#define _TIMIDITY_STRUCT_H




#ifdef TMDY___W32__
#include <windows.h>
#endif

#include "interface.h"

typedef struct s_tmdy_struct_ex_t tmdy_struct_ex_t;

typedef struct s_timidity_main_ex_t timidity_main_ex_t;
typedef struct s_output_ex_t output_ex_t;
typedef struct s_aq_ex_t aq_ex_t;
typedef struct s_controls_ex_t controls_ex_t;
typedef struct s_instrum_ex_t instrum_ex_t;
typedef struct s_resample_ex_t resample_ex_t;
typedef struct s_readmidi_ex_t readmidi_ex_t;
typedef struct s_playmidi_ex_t playmidi_ex_t;
typedef struct s_common_ex_t common_ex_t;
typedef struct s_filter_ex_t filter_ex_t;
typedef struct s_mix_ex_t mix_ex_t;
typedef struct s_sffile_ex_t sffile_ex_t;
typedef struct s_freq_ex_t freq_ex_t;
typedef struct s_mod_ex_t mod_ex_t;
typedef struct s_mod2midi_ex_t mod2midi_ex_t;
typedef struct s_m2m_ex_t m2m_ex_t;
typedef struct s_miditrace_ex_t miditrace_ex_t;
typedef struct s_wrd_ex_t wrd_ex_t;
typedef struct s_recache_ex_t recache_ex_t;
typedef struct s_quantity_ex_t quantity_ex_t;
typedef struct s_reverb_ex_t reverb_ex_t;
//#if defined(IA_WINSYN) || defined(IA_PORTMIDISYN) ||  defined(IA_W32G_SYN)
typedef struct s_rtsyn_ex_t rtsyn_ex_t;
//#endif
typedef struct s_utils_ex_t utils_ex_t;
typedef struct s_libunimod_ex_t libunimod_ex_t;
typedef struct s_libarc_ex_t libarc_ex_t;
//#ifdef TMDY_AUD_W32
typedef struct s_w32_a_ex_t w32_a_ex_t;
//#endif
//#ifdef TMDY_AUD_OSS
typedef struct s_oss_a_ex_t oss_a_ex_t;
//#endif
//#ifdef TMDY_AUD_PORTAUDIO
typedef struct s_portaudio_a_ex_t portaudio_a_ex_t;
//#endif
//#ifdef TMDY_AUD_ARTS
typedef struct s_arts_a_ex_t arts_a_ex_t;
//#endif
//#ifdef TMDY_AUD_JACK
typedef struct s_jack_a_ex_t jack_a_ex_t;
//#endif
//#ifdef TMDY_SUPPORT_SOUNDSPEC
typedef struct s_soundspec_ex_t soundspec_ex_t;
//#endif
//#ifdef IA_ALSASEQ
typedef struct s_alsaseq_c_ex_t alsaseq_c_ex_t;
//#endif
//#ifdef IA_SERVER
typedef struct s_server_c_ex_t server_c_ex_t;
//#endif

#if defined(TMDY___W32__)
typedef CRITICAL_SECTION  timidity_mutex_t;
#define timidity_mutex_init(_m)	InitializeCriticalSection(&_m)
#define timidity_mutex_destroy(_m) DeleteCriticalSection(&_m)
#define timidity_mutex_lock(_m)    EnterCriticalSection(&_m)
#define timidity_mutex_unlock(_m)  LeaveCriticalSection(&_m)
#elif defined(HAVE_PTHREAD_H)
#include <pthread.h>
typedef pthread_mutex_t timidity_mutex_t;
#define timidity_mutex_init(_m)      pthread_mutex_init(&(_m),NULL)
#define timidity_mutex_destroy(_m)   pthread_mutex_destroy(&(_m))
#define timidity_mutex_lock(_m)      pthread_mutex_lock(&(_m))
#define timidity_mutex_unlock(_m)    pthread_mutex_unlock(&(_m))
/*
typedef int timidity_mutex_t;
#define timidity_mutex_init(_m)      { (_m) = 0; }
#define timidity_mutex_destroy(_m) 
#define timidity_mutex_lock(_m) 
#define timidity_mutex_unlock(_m) 
*/
#else
typedef int timidity_mutex_t;
#define timidity_mutex_init(_m)      { (_m) = 0; }
#define timidity_mutex_destroy(_m) 
#define timidity_mutex_lock(_m) 
#define timidity_mutex_unlock(_m) 
#endif

struct s_tmdy_struct_ex_t {
	timidity_mutex_t  busy;
	timidity_main_ex_t *timidity_main;
	output_ex_t *output;
	aq_ex_t *aq;
	controls_ex_t *controls;
	instrum_ex_t *instrum;
	resample_ex_t *resample;
	readmidi_ex_t *readmidi;
	playmidi_ex_t *playmidi;
	common_ex_t *common;
	filter_ex_t *filter;
	mix_ex_t *mix;
	sffile_ex_t *sffile;
	freq_ex_t *freq;
	mod_ex_t *mod;
	mod2midi_ex_t *mod2midi;
	m2m_ex_t *m2m;
	miditrace_ex_t *miditrace;
	wrd_ex_t *wrd;
	recache_ex_t *recache;
	quantity_ex_t *quantity;
	reverb_ex_t *reverb;
//#if defined(IA_WINSYN) || defined(IA_PORTMIDISYN)  ||  defined(IA_W32G_SYN)
	rtsyn_ex_t *rtsyn;
//#endif
	utils_ex_t *utils;
	libunimod_ex_t *libunimod;
	libarc_ex_t *libarc;
//#ifdef TMDY_AUD_W32
	w32_a_ex_t *w32_a;
//#endif
//#ifdef TMDY_AUD_OSS
	oss_a_ex_t *oss_a;
//#endif
//#ifdef TMDY_AUD_PORTAUDIO
	portaudio_a_ex_t *portaudio_a;
//#endif
//#ifdef TMDY_AUD_ARTS
	arts_a_ex_t *arts_a;
//#endif
//#ifdef TMDY_AUD_JACK
        jack_a_ex_t *jack_a;
//#endif
//#ifdef TMDY_SUPPORT_SOUNDSPEC
        soundspec_ex_t *soundspec;
//#endif
//#ifdef IA_ALSASEQ
        alsaseq_c_ex_t *alsaseq_c;
//#endif
//#ifdef IA_SERVER
	server_c_ex_t *server_c;
//#endif

};

#define TMDY_MAIN tmdy_struct->timidity_main
#define TMDY_OUTPUT tmdy_struct->output
#define TMDY_AQ tmdy_struct->aq
#define TMDY_CONTROLS tmdy_struct->controls
#define TMDY_INSTRUM tmdy_struct->instrum
#define TMDY_RESAMPLE tmdy_struct->resample
#define TMDY_READMIDI tmdy_struct->readmidi
#define TMDY_PLAYMIDI tmdy_struct->playmidi
#define TMDY_COMMON tmdy_struct->common
#define TMDY_FILTER tmdy_struct->filter
#define TMDY_MIX tmdy_struct->mix
#define TMDY_SFFILE tmdy_struct->sffile
#define TMDY_FREQ tmdy_struct->freq
#define TMDY_MOD tmdy_struct->mod
#define TMDY_MOD2MIDI tmdy_struct->mod2midi
#define TMDY_M2M tmdy_struct->m2m
#define TMDY_MIDITRACE tmdy_struct->miditrace
#define TMDY_WRD tmdy_struct->wrd
#define TMDY_RECACHE tmdy_struct->recache
#define TMDY_QUANTITY tmdy_struct->quantity
#define TMDY_REVERB tmdy_struct->reverb
//#if defined(IA_WINSYN) || defined(IA_PORTMIDISYN)  ||  defined(IA_W32G_SYN)
#define TMDY_RTSYN tmdy_struct->rtsyn
//#endif
#define TMDY_UTILS tmdy_struct->utils
#define TMDY_UNIMOD tmdy_struct->libunimod
#define TMDY_ARC tmdy_struct->libarc
//#ifdef TMDY_AUD_W32
#define TMDY_W32_A tmdy_struct->w32_a
//#endif
//#ifdef TMDY_AUD_OSS
#define TMDY_OSS_A tmdy_struct->oss_a
//#endif
//#ifdef TMDY_AUD_PORTAUDIO
#define TMDY_PORTAUDIO_A tmdy_struct->portaudio_a
//#endif
//#ifdef TMDY_AUD_ARTS
#define TMDY_ARTS_A tmdy_struct->arts_a
//#endif
//#ifdef TMDY_AUD_JACK
#define TMDY_JACK_A tmdy_struct->jack_a
//#endif
//#ifdef TMDY_SUPPORT_SOUNDSPEC
#define TMDY_SOUNDSPEC tmdy_struct->soundspec
//#endif
//#ifdef IA_ALSASEQ
#define TMDY_ALSASEQ_C tmdy_struct->alsaseq_c
//#endif
//#ifdef IA_SERVER
#define TMDY_SERVER_C tmdy_struct->server_c
//#endif


//extern tmdy_struct_ex_t *tmdy_struct;

tmdy_struct_ex_t* new_tmdy_struct(void);
void destroy_tmdy_struct(tmdy_struct_ex_t* tmdy_struct);

#include "utils_export.h"
#include "arc_export.h"


#endif /* _TIMIDITY_STRUCT_H */
