#ifdef WIN32
#ifndef SUPPORT_H
#define SUPPORT_H

#pragma once
#include "stdafx.h"
#include "resource.h"
#include <string>
#include <vector>
#include <sstream>
using namespace std;


namespace NTF{


/*=======================================================================//
 
	MFCCString^̕std::stringɕϊB 

	str : ϊƂ̕ (CString)

	߂l : ϊꂽstd::string^̕

//=======================================================================*/
	inline std::string CstringToString(const CString& str)
	{
		char *buff = new char[ str.GetAllocLength() + 1 ];
		strcpy( buff , (LPCTSTR)str );

		std::string string(buff);

		delete [] buff;

		return string;
	}

/*=======================================================================//
 
	 Windows̃\[Xt@C當擾B
	
	nID : ʂӂ̔ԍ
	
	߂l : 擾B

			G[ : 󔒕Ԃ

//=======================================================================*/
	inline string loadResourceText(const UINT& nID)
	{
		CString s;

		ASSERT( s.LoadString(nID) );

		if( !s.LoadString( nID ) )
		{
			string tmp("");
			return tmp;
		}	

		char *buff = new char[ s.GetAllocLength() + 1 ];

		strcpy( buff , (LPCTSTR)s );

		std::string string(buff);

		delete [] buff;

		return string;
	}

/*=======================================================================//
 
	 kb/secPʂbpsPʂ֕ϊB
	
	kb : kb킷

	߂l : bps킷
	
//=======================================================================*/
	inline long KB_secToBps(long kb){
		return kb * 1024 * 8;
	}

/*=======================================================================//
 
	 BpsPʂkb/secPʂ֕ϊB

	 bps : bps킷

	߂l : kb/sec킷
	
//=======================================================================*/
	inline long BpsToKB_sec(long bps)
	{
		if( 0 == bps ){return 0;}
		return bps / 8 / 1024;
	}

/*=======================================================================//
 
	T[o[NCAgɃ`bgbZ[W𑗐M鎞
	gp镶̃tH[}bgɕϊ
	
	ioString : ϊ̕B͕ύXB
	
//=======================================================================*/
	inline void ToChatStyleString(string& ioString)
	{
		ioString.insert( 0 , NTF::loadResourceText( IDS_CHAT_HEADER ) );
		ioString.append( NTF::loadResourceText( IDS_CHAT_FODDER ) );
	}

/*=======================================================================//
 
	𕶎^(std::string)ɕϊB
	
	num : ϊ̐

	߂l : ϊstd::string^̕
	
//=======================================================================*/
	template <class number>
		inline string toString(number num)
	{
		stringstream ss;
		string text;
		ss << num;
		ss >> text;
		return text;
	}

/*=======================================================================//
 
	񒆂Ɋ܂܂Aׂ̕ĒuB
	
	source : ϊ̕B͕ύXB
	pattern : ύX^[Qbg̕
	placement : ύXɗp镶
	
//=======================================================================*/
	template<typename E, typename T, typename A>
		inline
		std::basic_string<E,T,A>
		replace_all_target(
		const std::basic_string<E,T,A>& source,
		const std::basic_string<E,T,A>& pattern,
		const std::basic_string<E,T,A>& placement
		) 
	{
		std::basic_string<E,T,A> result(source);
		for ( std::string::size_type pos = 0 ;
			std::string::npos != (pos = result.find(pattern,pos));
			pos += placement.size() )
			result.replace(pos, pattern.size(), placement);
		return result;
	}

//-----------------------------------------------------------------------//
//2003/07/22 added by ortana.use for SHFileOperation of Win32API
//-----------------------------------------------------------------------//
	inline void setDoubleNullChar( char * buff )
	{
		char *temp = (char*)memchr( buff , '\0' , MAX_PATH );
		if( temp != NULL )
		{
			temp++;
			*temp = '\0';
		}
	}

	#pragma warning( disable : 4244 )
//-----------------------------------------------------------------------//
//added by ortana.
//-----------------------------------------------------------------------//
	inline void longToByteArray(char * array , long l)
	{
		*(array)	 = ((l >> 24) & 0xff);
		*(++array)	 = ((l >> 16) & 0xff);
		*(++array)	 = ((l >> 8 ) & 0xff);
		*(++array)	 = (l  & 0xff);
	}

//-----------------------------------------------------------------------//
//added by ortana.
//-----------------------------------------------------------------------//
	inline int GetDaycountOfMonth(int y, int m)
	{
		assert( y > 0  );assert( y < 13 );
		assert( m > 0  );assert( m < 13 );

		int magic[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

		if ((y % 4 == 0) && ((y % 100 != 0) || (y % 400 == 0))) {
			/* when Leap year */
			++magic[1];
		}

		return magic[m - 1];
	}

	void splitString(const string &inString,const string &inDelimiter,
														vector<string> &outStrings);


}//NTF

#endif//SUPPORT_H
#endif//WIN32