/*//////////////////////////////////////////////////////////////////////////
 
  FindCommand Class
	

		command for find files.

		//2003/08/29 added by ortana. 

//////////////////////////////////////////////////////////////////////////*/
#ifdef WIN32
#pragma once
#include "AbstractCommand.h"
#undef _WINDOWS_
#include "afxwin.h"
#include <map>

const std::string FIND_COMMAND					= "/find";
const int FIND_FOLDER_LIMIT = 20;
const int FIND_FILE_LIMIT		= 30;

class FindCommand : public AbstractCommand
{
public:

	FindCommand(HLClient* client);
	~FindCommand(void);
	const virtual bool Process( CommandParam& param );
	inline const std::string& GetParameter()  const{ return parameter;}
	inline const std::string& GetChatString() const{ return chatString;}
	inline const int& GetCount() const{ return foundCount; }
	void Initialize(char* rootPath);
	const int Find(LPCTSTR fld, LPCTSTR wcd, 
					std::string &outFindList,
					int count);
	inline void SetUsingFlag(const bool& value){ this->isUsingCommand = value; }

protected :
	
	FindCommand(void){}

private :
	
	FindCommand& operator=(const FindCommand& command );
	

public :

protected :

	mutable std::string chatString;
	std::string parameter;
	HANDLE findThread;

private :

	int foundCount;
	char* rootPath;
	std::map< std::string , std::string > shortcutList;

};
#endif//WIN32