#ifdef WIN32

#include "prefix.h"
#include "FindCommand.h"
#include "FileUtils.h"
#include "HLServer.h"
#include <iterator>
#include "CommandParam.h"
#include "Support.h"

unsigned __stdcall FindThreadProc( void* pParam );


FindCommand::FindCommand(HLClient *client) : AbstractCommand( client )
{
	this->findThread = 0;
} 



FindCommand::~FindCommand(void)
{
	try
	{
		if( this->findThread != 0 )
		{
			::WaitForSingleObject( this->findThread , INFINITE );
		}
	}
	catch( ... ){}
}



/////////////////
//public

const bool FindCommand::Process( CommandParam& param )
{
	if( !PreProcess( FIND_COMMAND, param ) )
	{
		return false;
	}

	chatString = param.GetChatString();

	if( !ExtractParameter( chatString , FIND_COMMAND.length() , this->parameter ) )
	{
		string badParam( NTF::loadResourceText( IDS_CHAT_CMD_BAD_PARAMETER ) );
		NTF::ToChatStyleString( badParam );
		SendChat(badParam);
		return false;
	}
	else
	{
		string searching( NTF::loadResourceText( IDS_CHAT_CMD_SEARCHING ) );
		NTF::ToChatStyleString( searching );
		SendChat( searching );
		
		//Create the second thread.
		unsigned threadID;
		findThread = (HANDLE)_beginthreadex( NULL, 0, &FindThreadProc, this , 0, &threadID );

	}
	return true;
}

void FindCommand::Initialize(char * rootPath)
{
	this->rootPath = rootPath;
	this->foundCount = 0;
	this->shortcutList.clear();
}



const int FindCommand::Find(LPCTSTR fld, LPCTSTR wcd,std::string &outFindList,int count)
{
	try
	{
		if( count > FIND_FOLDER_LIMIT )
		{
			return this->foundCount;
		}

		HANDLE dno;
		TCHAR  dir[MAX_PATH];
		WIN32_FIND_DATA fil;
		string extension;


		// files
		lstrcat(lstrcpy(dir, fld), wcd);
		if ((dno = FindFirstFileA(dir, &fil)) != INVALID_HANDLE_VALUE) {

			do//-------------do while---------------/
			{
				if ((fil.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != FILE_ATTRIBUTE_DIRECTORY)
				{
					this->foundCount++;
					if( this->foundCount > FIND_FILE_LIMIT )
					{
						FindClose(dno);
						return this->foundCount;
					}

					TCHAR full_path[MAX_PATH];
					lstrcat(lstrcpy(full_path, fld), fil.cFileName);
					std::string	raw_path( full_path );

					//lnk folder
					for ( std::map< std::string , std::string >::iterator i = shortcutList.begin();
						i != shortcutList.end();
						++i )
					{
						string tmp = i->first;
						if( raw_path.find( i->first ) != string.npos )
						{
							raw_path.erase( 0 , (i->first).length() );
							raw_path.insert( 0 , i->second );
							break;
						}
					}

					raw_path = raw_path.erase( 0 , (strlen( this->rootPath ) - 1) );
					std::string p("\\");
					std::string pr("/");
					raw_path = NTF::replace_all_target( raw_path , p , pr );
					raw_path = raw_path.insert( 0 , NTF::loadResourceText( IDS_CHAT_HEADER ) );
					raw_path = raw_path.append( NTF::loadResourceText( IDS_CHAT_FODDER ) );

					outFindList.append( raw_path );
				}
			}
			while(FindNextFileA(dno, &fil) != 0);//do while

			FindClose(dno);
		}

		// directory
		lstrcat(lstrcpy(dir, fld), "*");
		if ((dno = FindFirstFileA(dir, &fil)) == INVALID_HANDLE_VALUE)
		{
			return 0;
		}

		do//-------------do while---------------//
		{
			if ((fil.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
			{
				if( this->foundCount > 30 )
				{
					FindClose(dno);
					return this->foundCount;
				}

				//drop box
				if( FileUtils::noCaseStrStr( fil.cFileName , "drop boxes" ) )
				{
					continue;
				}
				if(FileUtils::noCaseStrStr( fil.cFileName , "drop box" ) )
				{
					continue;
				}

				TCHAR dir_path[MAX_PATH];
				if (strcmp(fil.cFileName, ".") == 0 || strcmp(fil.cFileName, "..") == 0) continue;

				lstrcat(lstrcat(lstrcpy(dir_path, fld), fil.cFileName), "\\");
				Find(dir_path, wcd,outFindList ,count + 1);
			}
		}
		while(FindNextFileA(dno, &fil) != 0);//do while
		FindClose(dno);


		// lnk file
		lstrcat(dir , ".lnk");
		if ((dno = FindFirstFileA(dir, &fil)) == INVALID_HANDLE_VALUE)
		{
			return 0;
		}

		do//-------------do while---------------//
		{
			TCHAR full_path[MAX_PATH];
			lstrcat(lstrcpy(full_path, fld), fil.cFileName);
			std::string	raw_path( full_path );
			char sourcePath[MAX_PATH];
			FileUtils::resolve_Link( sourcePath ,(LPSTR)raw_path.data() );
			if( !FileUtils::IsExistObject( sourcePath , TRUE ) )
			{
				continue;
			}

			shortcutList[ sourcePath ] = raw_path;

			strcat( sourcePath , "\\" );
			Find(sourcePath, wcd ,outFindList,count + 1);
			continue;
		}
		while(FindNextFileA(dno, &fil) != 0);//do while
		FindClose(dno);

	}
	catch( ... ){}

	return this->foundCount;
}



//=======================================================================//
// thread function.
//=======================================================================//    
unsigned __stdcall FindThreadProc( void* pParam )
{
	try
	{
		FindCommand *cmd = (FindCommand *)pParam;


		char wild[MAX_PATH];

		sprintf(wild , "*%s*" , cmd->GetParameter().c_str() );

		char fileFolder[MAX_PATH];
		FileUtils::getAbsolutePath(gServer->Config().rootPath, fileFolder );

		const char  directoryMark[] = "\\";
		if( strcmp( &fileFolder[ strlen( fileFolder ) - 1 ] , directoryMark ) != 0 )
		{
			strcat( fileFolder , "\\" );
		}

		//now find files.
		cmd->Initialize(fileFolder);
		std::string outFindList;
		cmd->Find( fileFolder , wild , outFindList , 0);

		const int ret = cmd->GetCount();
		
		if( ret == 0 )
		{
			string notFound( NTF::loadResourceText( IDS_CHAT_CMD_NOT_FOUND_FILE ) );
			NTF::ToChatStyleString( notFound );
			cmd->SendChat(notFound);
		}
		else
		{
			string foundFile( NTF::loadResourceText( IDS_CHAT_CMD_FOUND_FILE ) );
			NTF::ToChatStyleString( foundFile );
			outFindList.insert( 0 , foundFile );
			if( ret > FIND_FILE_LIMIT )
			{
				outFindList.append( NTF::loadResourceText( IDS_CHAT_HEADER ) );
				outFindList.append( NTF::loadResourceText( IDS_CHAT_CMD_FOUND_FILE_OVER_LIMIT_HEADER ));

				outFindList.append(NTF::toString( FIND_FILE_LIMIT ));
				outFindList.append(NTF::loadResourceText( IDS_CHAT_CMD_FOUND_FILE_OVER_LIMIT_FODDER ) );
				outFindList.append(NTF::loadResourceText( IDS_CHAT_FODDER ));
			}
			cmd->SendChat( outFindList );
		}

		cmd->SetUsingFlag( false );
	}
	catch( ... ){}
	return 0;
}


#endif//WIN32