#ifdef WIN32
#include "prefix.h"
#include "diskfreespacecommand.h"
#include "FileUtils.h"
#include <windows.h>
#include "HLServer.h"
#include "CommandParam.h"
#include "Support.h"



DiskFreeSpaceCommand::DiskFreeSpaceCommand(HLClient* client)
: AbstractCommand( client )
{
}

DiskFreeSpaceCommand::~DiskFreeSpaceCommand(void)
{
}

////////////////
//public

const bool DiskFreeSpaceCommand::Process( CommandParam& param )
{
	if( !PreProcess( DISK_FREE_SPACE_COMMAND, param ) )
	{
		return false;
	}

	ULARGE_INTEGER freeDisk;
	char fileFolder[MAX_PATH];
	FileUtils::getAbsolutePath(gServer->Config().rootPath, fileFolder );
	this->FreeDiskSpace( fileFolder , &freeDisk );

	string outString;
	FileUtils::formatSize( freeDisk.QuadPart , outString );

	outString = outString.insert( 0 , NTF::loadResourceText( IDS_CHAT_CMD_FREE_DISK_SPACE_HEADER ) );
	outString = outString.append( NTF::loadResourceText(IDS_CHAT_CMD_FREE_DISK_SPACE_FODDER) );
	NTF::ToChatStyleString( outString );

	this->SendChat( outString );

	isUsingCommand = false;
	return true;

}

//---------------------------------------------------------------------
// get free disk space
//
// pram
//      lpDirectoryName
//          directory name with drive letter.
//      lpFreeBytes
//					(out) free bytes
//
// return
//     false : 0
// 
//   Header: winnetwk.h 
//	 Library:mpr.lib
//---------------------------------------------------------------------
BOOL DiskFreeSpaceCommand::FreeDiskSpace(
	LPCTSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytes)
{
	GETDISKFREESPACEEX fnGetDiskFreeSpaceEx;
	fnGetDiskFreeSpaceEx = (GETDISKFREESPACEEX)GetProcAddress(
		GetModuleHandle("kernel32.dll"), "GetDiskFreeSpaceExA");

	if ( fnGetDiskFreeSpaceEx )
	{
		ULARGE_INTEGER totalbytes;
		return fnGetDiskFreeSpaceEx(lpDirectoryName,
			lpFreeBytes, &totalbytes, NULL);
	}

	TCHAR szPath[_MAX_PATH];

	//UNC
	if ( lpDirectoryName[0] == '\\' && lpDirectoryName[1] == '\\' )
	{
		lstrcpy(szPath, "C:\\");
		while (GetDriveType(szPath) != DRIVE_NO_ROOT_DIR)
		{
			szPath[0] ++;
			if (szPath[0] > 'Z')
				return FALSE;
		}
		szPath[2] = '\0';
		if (WNetAddConnection(lpDirectoryName,
			NULL, szPath) != NO_ERROR)
			return FALSE;
	}
	else
	{
		TCHAR szDrive[_MAX_DRIVE];
		_tsplitpath(lpDirectoryName, szDrive, NULL, NULL, NULL);
		_tmakepath(szPath, szDrive, "\\", NULL, NULL);
	}

	DWORD dwSectorsPerCluster, dwBytesPerSector,
		dwNumberOfFreeClusters, dwTotalNumberOfClusters;
	BOOL bResult;
	bResult = GetDiskFreeSpace(szPath, &dwSectorsPerCluster,
		&dwBytesPerSector, &dwNumberOfFreeClusters,
		&dwTotalNumberOfClusters);

	if ( lpDirectoryName[0] == '\\' && lpDirectoryName[1] == '\\' )
		WNetCancelConnection(szPath, FALSE);

	if (bResult)
	{
		lpFreeBytes->QuadPart = (ULONGLONG)dwSectorsPerCluster *
			dwBytesPerSector * dwNumberOfFreeClusters;
	}

	return bResult;
}
#endif//WIN32