// Used for logging possible errors that could occur during runtime
// and logging users actions with the server
#ifndef SERVERLOG_H
#define SERVERLOG_H

#include <stdio.h>
#include <stdlib.h>



#if !defined(WIN32)
#include <unistd.h>
#else
#pragma once
#undef _WINDOWS_
#include "afxwin.h"
#endif//!WIN32

#include "HLClient.h"

const char AccountActionCreate[] = "Create";
const char AccountActionModify[] = "Modify";
const char AccountActionDelete[] = "Delete";

			//2003/07/24 added by ortana.
#ifdef WIN32
		extern CEdit *log_Edit;
#endif

namespace ServerLog
{
			//2003/07/24 added by ortana.
#ifdef WIN32
	extern	CEdit *log_Edit;
	void ShowLog(const char *log,CEdit *edit);
	void OtherLog(const char *header , const char *log);
#endif

    void AccountLog(HLClient &inClient, const char *inAction, const char *inAffectedAccount);
    void ConnectLog(HLClient &inClient);
    void DownloadLog(HLClient &inClient, const char *inFileName);
    void UploadLog(HLClient &inClient, const char *inFileName);
    void ErrorLog(char *inSourceFile, unsigned int inSourceLine, const char *inFormat, ...);
} // end namespace ServerLog

#endif // SERVERLOG_H


