#if defined(CONFIG_THREADEDNEWS)

#include "HLNewsFile.h"
#include "NewsUtils.h"
#include "FileUtils.h"
#include <fcntl.h>
#ifndef WIN32
#include <dirent.h>
#include <unistd.h>
#include <sys/errno.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <sys/param.h>
#endif//!WIN32
#include <stdlib.h>
#include "dirchar.h"

/* 	These functions handle reading/writing of file-based threaded news.
I would imagine that HLDatabase should handle generic news functions,
calling functions in NewsUtils when a file-based news implementation
is used as opposed to a database implementation. -- jcb */

using namespace NewsUtils;
using namespace FileUtils;
using namespace NewsFile;



/*=======================================================================//
	 
	Xbhj[X̃tH_AJeS𑖍
	NCAgɑMB


	inPath : j[X݂̑郋[gtH_
	ioPacket : 󂯎pPbgBNCAgMɗpB

//=======================================================================*/    
bool NewsUtils::listBundle(const string &inPath, HLPacket &ioPacket)
{
	char hdrDataBuf[SIZEOF_HL_BUNDLELIST_BUNDLE_HDR + 255];

	// this is booty -jcb
	struct hl_bundlelist_bundle_hdr		*bundleHdr = (struct hl_bundlelist_bundle_hdr *)hdrDataBuf;
	struct hl_bundlelist_category_hdr	*categoryHdr = (struct hl_bundlelist_category_hdr *)hdrDataBuf;

	u_int16_t ntype = 0;

#ifdef WIN32
	char sPath[MAX_PATH];
	FileUtils::getAbsolutePath( inPath.c_str() , sPath );
	string filePath( sPath );
	string rootPath( sPath );
	sprintf( sPath , "%s*" , sPath );
	WIN32_FIND_DATA FindFileData;
	HANDLE  hDir = FindFirstFileA( sPath , &FindFileData );
	if( hDir == INVALID_HANDLE_VALUE )
	{
		return false;
	}


	do{//------------do while----------//
		if( FindFileData.cFileName[0] == '.' ||
			(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) ||
			(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) )
		{
			continue;
		}

		filePath.assign(rootPath);
		string fileName(FindFileData.cFileName);
		filePath.append( fileName );


		if( GetDriveType( fileName.c_str() ) > 1 )
		{
			FindFileData.dwFileAttributes = 17;
			filePath.append("*");

			bundleHdr->ntype = ntype = 2;
			bundleHdr->count = htonl(FileUtils::countAllFile( filePath.c_str() ));
		}
		else if(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )//folder
		{
			filePath.append("\\*");

			bundleHdr->ntype = ntype = 2;
			bundleHdr->count = htonl(FileUtils::countAllFile( filePath.c_str() ));

		}
		else//file
		{

			HLNewsFile newsFile(filePath);

			if (newsFile.FileValid())
			{
				categoryHdr->ntype = ntype = 3;
				categoryHdr->count = htonl(newsFile.GetHdr()->post_count);
				//this is horrible.. fix this...
				memcpy(categoryHdr->junk, &newsFile.GetHdr()->uuid, sizeof(uuid_t));
				categoryHdr->count2 = htonl(newsFile.GetHdr()->post_count + 1); // fun
				categoryHdr->unknown = 1; // this is always 1
			}	
		}

		
		HomeToNetworkString(fileName);

		if (ntype == 2)
		{
			bundleHdr->ntype = htons((u_int16_t)2);
			bundleHdr->nlen = /*htonl(*/(u_int32_t)fileName.length()/*)*/;
			memcpy(bundleHdr->name, fileName.c_str(), fileName.length());
			ioPacket.AddObject(HTLS_DATA_NEWS_BUNDLELIST,
				SIZEOF_HL_BUNDLELIST_BUNDLE_HDR + fileName.length(), (char *)bundleHdr);
		}
		else
		{
			categoryHdr->ntype = htons((u_int16_t)3);
			categoryHdr->nlen =/*htonl(*/(u_int32_t)fileName.length()/*)*/;

			memcpy(categoryHdr->name, fileName.c_str(), fileName.length());
			ioPacket.AddObject(HTLS_DATA_NEWS_BUNDLELIST,
				SIZEOF_HL_BUNDLELIST_CATEGORY_HDR + fileName.length(), (char *)categoryHdr);
		}


	} while(FindNextFile(hDir, &FindFileData));//------------do while----------//

	FindClose(hDir);

#else

	DIR *dir;
	struct stat sb;
	dir = opendir(inPath.c_str());
	if (dir == NULL)
	{
		return false;
	}
	struct dirent *de;
	while ((de = readdir(dir)) != NULL)
	{
		//bool isLink = false;
		bool isValid = true;
		string fileName(de->d_name);

		if (fileName[0] != '.')
		{
			string filePath(inPath);
			filePath.append(fileName);

#if defined(_CARBON_)
			resolveAlias(filePath);
			FSRef theRef;
			if (PathToFSRef(filePath, &theRef))
			{
				FSCatalogInfo catInfo;
				if (FSGetCatalogInfo(&theRef, kFSCatInfoFinderInfo,
					&catInfo, NULL, NULL, NULL) == noErr)
				{
					FInfo *finderInfo = (FInfo *)catInfo.finderInfo;
					if (finderInfo->fdFlags & kIsInvisible)
					{
						isValid = false;
					}
				}
				else
					isValid = false;
			}
			else
				isValid = false;
#endif // _CARBON_
			if (isValid)
			{
				if (lstat(filePath.c_str(), &sb) == 0)
				{
					if (S_ISDIR(sb.st_mode))
					{
						bundleHdr->ntype = ntype = 2;
						// count sub items
						DIR *subDir = opendir(filePath.c_str());
						u_int32_t subItemCount = 0;
						if (subDir)
						{
							struct dirent *subDe;
							while ((subDe = readdir(subDir)) != NULL)
							{
								string subFileName(subDe->d_name);
								if (subFileName[0] != '.')
									subItemCount++;
							}
							closedir(subDir);
						}
						bundleHdr->count = htonl(subItemCount);
					}
					else
					{
						HLNewsFile newsFile(filePath);

						if (newsFile.FileValid())
						{
							categoryHdr->ntype = ntype = 3;
							categoryHdr->count = newsFile.GetHdr()->post_count;
							//this is horrible.. fix this...
							memcpy(categoryHdr->junk, &newsFile.GetHdr()->uuid, sizeof(uuid_t));
							categoryHdr->count2 = categoryHdr->count + 1; // fun
							categoryHdr->unknown = 1; // this is always 1
						}						
					}
				}

				HomeToNetworkString(fileName);

				if (ntype == 2)
				{
					bundleHdr->nlen = htonl((u_int32_t)fileName.length());
					memcpy(bundleHdr->name, fileName.c_str(), fileName.length());
					ioPacket.AddObject(HTLS_DATA_NEWS_BUNDLELIST,
						SIZEOF_HL_BUNDLELIST_BUNDLE_HDR + fileName.length(), (char *)bundleHdr);
				}
				else
				{
					categoryHdr->nlen = htonl((u_int32_t)fileName.length());

					memcpy(categoryHdr->name, fileName.c_str(), fileName.length());
					ioPacket.AddObject(HTLS_DATA_NEWS_BUNDLELIST,
						SIZEOF_HL_BUNDLELIST_CATEGORY_HDR + fileName.length(), (char *)categoryHdr);
				}
			}
		}
	}
	closedir(dir);
#endif//WIN32

	return true;
}

/*=======================================================================//
 
	XbhyыLǉB
	
	inPath : ݂ɎgpJeSt@C̃pX
	inParentID : eXbĥhc
	inTitle : Xbh̃^Cg
	inAuthor : jbNl[
	inPostData : Le
	inPostDataLen  : L̕
	
//=======================================================================*/
bool NewsUtils::addThread(const string &inPath, u_int32_t inParentID, const string &inTitle, const string &inAuthor, const char *inPostData, u_int16_t inPostDataLen)
{	
	HLNewsFile	file(inPath);

	//u_int32_t	n;
	u_int32_t	bestmap = 1;

	pmap_t		*postmap;//XbhIDpost_info_tւ̈ʒu
	u_int32_t	postmap_block;
	u_int32_t	postmap_count;

	post_info_t	postinfo;//eĂL̏BLւ̈ʒu^CgAeҖȂǁB
	u_int32_t	postinfo_block;

	post_data_t *postdata;//eꂽL̓eyу^Cv
	u_int32_t	postdata_block;

	int	block;

	// find the the best (lowest post count) postmap

	DEBUG_CALL(printf( "file.BlockSize() = %d\n" , file.BlockSize() ));
		
DEBUG_CALL(printf("file.mMainMap[bestmap].count = %d\n" , file.mMainMap[bestmap].count ));
	for (unsigned int i = 0; i < file.BlockSize() / sizeof(map_t); i++) // iterate through the main map
	{
		DEBUG_CALL(printf("file.mMainMap[i].count = %d\n" , file.mMainMap[i].count ) );
		if (file.mMainMap[i].count < file.mMainMap[bestmap].count) // a lower post count is preferred (why? --jcb)
			bestmap = i;
	}

	// fixme.. check to see if the end of the file is on a block boundary before proceeding

	DEBUG_CALL(printf("postheader_size = %d\n" , file.GetHdr()->postheader_size ));
	if (file.GetHdr()->postheader_size == 0) //headers dont exist
	{
		file.mFile.seekp(0, ios::end);
		block = ((u_int32_t)file.mFile.tellg() - 0x200) / file.BlockSize() + 1;
	}
	else
	{
		DEBUG_CALL(printf("file.GetHdr()->postheader_block = %d\n" , file.GetHdr()->postheader_block ));
		block = file.GetHdr()->postheader_block;//t@Cwb_[(file_hdr_t)̈ʒuH傫H擾
	}

	// we'll have to create the postmap from scratch
	DEBUG_CALL(printf("file.mMainMap[bestmap].block = %d\n" , file.mMainMap[bestmap].block ));
	if (file.mMainMap[bestmap].block == 0)
	{
		postmap = (pmap_t*)malloc(file.BlockSize());
		postmap_count = 0;
		postmap_block = block;
		block++;
	}
	// the postmap is full so we'll need to rewrite it
	else if ((file.mMainMap[bestmap].count != 0) && ((file.mMainMap[bestmap].count * sizeof(pmap_t)) % file.BlockSize() == 0)) // map is full
	{
		postmap_count = file.mMainMap[bestmap].count;
		postmap = (pmap_t*)malloc((postmap_count + 1) * sizeof(pmap_t));
		if (file.ReadBlocks(file.mMainMap[bestmap].block, (char*)postmap, postmap_count * sizeof(pmap_t)))
		{
			postmap_block = block;
			block += ((postmap_count + 1) * sizeof(pmap_t) - 1) / file.BlockSize() + 1;
		}
		else
		{
			free(postmap);
			return false;
		}
	}
	// the postmap exists and doesn't need to be rewritten
	else
	{
		postmap_count = file.mMainMap[bestmap].count;
		postmap = (pmap_t*)malloc((postmap_count + 1) * sizeof(pmap_t));
		postmap_block = file.mMainMap[bestmap].block;
		if (file.ReadBlocks(postmap_block, (char*)postmap, postmap_count * sizeof(pmap_t)) == false)
		{
			free(postmap);
			return false;
		}
	}

	postinfo_block = block;
	block++;

	postdata_block = block;
	DEBUG_CALL(printf("malloc postdata\n"));
	postdata = (post_data_t*)malloc((sizeof(post_data_t) + inPostDataLen));

	postdata->__x0 = 0;
	postdata->data_len = inPostDataLen;
	postdata->mimetype_len = 10;
	strncpy((char*)postdata->mimetype, "text/plain", 11);
	memcpy((char*)postdata->data, inPostData, postdata->data_len);

	postinfo.postdata_block = postdata_block;
	postinfo.__x0 = 0xC0;
	strncpy((char*)postinfo.mimetype, "application/x-hlnewsitem", 27);
	postinfo.mimetype_len = strlen("application/x-hlnewsitem");
	postinfo.id = file.GetHdr()->next_id;
	postinfo.previous_id = 0;
	postinfo.next_id = 0;
	postinfo.parent_id = inParentID;
	postinfo.reply_id = 0;
	postinfo.date_base = 1904;
	postinfo.date_sec = 0;
	postinfo.__x1 = 0;
	postinfo.title_len = inTitle.length();
	strncpy((char*)postinfo.title, inTitle.c_str(), 63);
	postinfo.author_len = inAuthor.length();
	strncpy((char*)postinfo.author, inAuthor.c_str(), 31);
	postinfo.email_len = strlen("http://terra.berkleyidiots.com");
	strncpy((char*)postinfo.email, "http://terra.berkleyidiots.com", 91);

	postmap[postmap_count].id = file.GetHdr()->next_id;
	postmap[postmap_count].block = postinfo_block;
	postmap_count++;

	file.mMainMap[bestmap].count++;
	file.mMainMap[bestmap].block = postmap_block;
	file.ReadPostHeaders();

	if (file.WriteBlocks(postmap_block, (char*)postmap, postmap_count * sizeof(pmap_t)))
	{
		if (file.WriteBlocks(postinfo_block, (char*)&postinfo, sizeof(post_info_t)))
		{
			if (file.WriteBlocks(postdata_block, (char*)postdata, sizeof(post_data_t) + postdata->data_len))
			{
				file.mPostHeaders->count++;
				file.mFile.seekp(0, ios::end);
				block = file.mFile.tellp();
				//printf("tellp: %x, block: %u\n", file.mFile.tellp(), block);
				file.mFile.write((char*)file.mPostHeaders, file.GetHdr()->postheader_size);
				file.mFile.write((char*)&postinfo.id, 4);
				file.mFile.write((char*)&postinfo.date_base, 4);
				file.mFile.write((char*)&postinfo.date_sec, 4);
				file.mFile.write((char*)&postinfo.parent_id, 4);
				file.mFile.write("\0\0\0\0", 4);
				file.mFile.write("\0\1", 2);
				file.mFile.write((char*)&postinfo.title_len, 1);
				file.mFile.write((char*)postinfo.title, postinfo.title_len);
				file.mFile.write((char*)&postinfo.author_len, 1);
				file.mFile.write((char*)postinfo.author, postinfo.author_len);
				file.mFile.write((char*)&postinfo.mimetype_len, 1);
				file.mFile.write((char*)postinfo.mimetype, postinfo.mimetype_len);
				u_int16_t postlen = postdata->data_len;
				file.mFile.write((char*)&postlen, 2);

				file.GetHdr()->postheader_block = (block - 0x200) / file.BlockSize() + 1;
				file.GetHdr()->postheader_size = (unsigned int)file.mFile.tellp() - block;

				file.GetHdr()->post_count++;
				file.GetHdr()->next_id++;

				if (file.UpdateHeader() && file.UpdateMainMap())
				{
					free(postdata);
					free(postmap);
					return true;
				}
			}
		}
	}

	free(postdata);
	free(postmap);
	return false;

}

/*=======================================================================//
 
	Lǂݏo

	inPath : Xbh܂܂JeSt@Cւ̃pX
	inThreadID : L\ID
	ioPacket   : Le𑗐M邽߂ɎgppPbg
	
//=======================================================================*/
bool NewsUtils::getThread(const string &inPath, u_int16_t inThreadID, HLPacket &ioPacket)
{
	DEBUG_CALL(printf("NewsUtils::getThread()\n"));

	HLNewsFile	file(inPath);

	pmap_t		*postmap;

	DEBUG_CALL(printf("malloc postmap\n"));
	postmap = (pmap_t*)malloc(file.BlockSize());

	for (unsigned int n = 0; n < file.BlockSize() / sizeof(map_t); n++)
	{
		if (file.mMainMap[n].count > 0)
		{
			if (file.ReadBlocks(file.mMainMap[n].block, postmap, file.mMainMap[n].count * sizeof(pmap_t)))
			{
				post_info_t postinfo;
				post_data_t *postdata;

				DEBUG_CALL(printf("malloc postdata\n"));
				postdata = (post_data_t*)malloc(65536 + sizeof(post_data_t));

				for (unsigned int m = 0; m < file.mMainMap[n].count; m++)
				{
					if (postmap[m].id == inThreadID)
					{
						if (file.ReadBlocks(postmap[m].block, (char*)&postinfo, file.BlockSize()))
						{
							if (file.ReadBlocks(postinfo.postdata_block, (char*)postdata, sizeof(post_data_t)))
							{
								if (postdata->data_len > 65535)
									postdata->data_len = 65535;

								if (file.ReadBlocks(postinfo.postdata_block, (char*)postdata, sizeof(post_data_t) + postdata->data_len))
								{
									ioPacket.AddObject(HTLS_DATA_NEWS_POST, postdata->data_len, (char*)postdata->data);
									ioPacket.AddObject(HTLS_DATA_NEWS_SUBJECT, postinfo.title_len, (char*)postinfo.title);
									ioPacket.AddObject(HTLS_DATA_NEWS_POSTER, postinfo.author_len, (char*)postinfo.author);
									ioPacket.AddObject(HTLS_DATA_NEWS_MIMETYPE, postdata->mimetype_len, (char*)postdata->mimetype);

									free(postdata);
									free(postmap);

									return true;
								}
							}
						}

						DEBUG_CALL(printf("free postdata\n"));
						DEBUG_CALL(printf("free postmap\n"));
						free(postdata);
						free(postmap);
						return false;

					}
				}

				DEBUG_CALL(printf("free postdata\n"));
				free(postdata);
			}
		}
	}

	DEBUG_CALL(printf("free postmap\n"));
	free(postmap);
	return false;
}

/*=======================================================================//
 
	JeSXg擾B
	
	inPath : JeSt@Cւ̃pX
	ioPacket : NCAgɑM邽߂ɎgppPbg
	
//=======================================================================*/
bool NewsUtils::listCategory(const string &inPath, HLPacket &ioPacket)
{	
	DEBUG_CALL(printf("NewsUtils::listCategory()\n"));

	HLNewsFile	file(inPath);

	if (file.FileValid())
	{
		if (file.ReadPostHeaders())
		{
			// fix this
			// if the postheader size is over 64k, the last 64k should be sent, not the first 64k -- jcb
			ioPacket.AddObject(HTLS_DATA_NEWS_CATLIST, file.GetHdr()->postheader_size > 65535 ? 65535 : file.GetHdr()->postheader_size, (char*)file.mPostHeaders);
		}

		return true;
	}
	else
	{
		return false;
	}
}

/*=======================================================================//
 
	JeSt@C쐬B
	
	inPath : 쐬ohitH_jւ̃pX
	inFileName : JeS[
	
//=======================================================================*/
bool NewsUtils::createNewsFile(const string &inPath, const string &inFileName)
{
	ofstream		file((inPath + inFileName).c_str(), ios::out | ios::binary);
	char			buffer[256];
	file_hdr_t		hdr;

	memcpy(&hdr.magic, HLNZ_MAGIC, HLNZ_MAGIC_LEN);
	memset(buffer, 0, 256);

	// this should actually fill in a uuid
	hdr.uuid.time_low = 0;
	hdr.uuid.time_mid = 0;
	hdr.uuid.time_hi_and_version = 0;
	hdr.uuid.clock_seq_hi_and_reserved = 0;
	hdr.uuid.clock_seq_low = 0;
	hdr.uuid.node[0] = 0;
	hdr.uuid.node[1] = 0;
	hdr.uuid.node[2] = 0;
	hdr.uuid.node[3] = 0;
	hdr.uuid.node[4] = 0;
	hdr.uuid.node[5] = 0;

	hdr.__x0 = htonl(1);
	hdr.__x1 = htonl(1);

	hdr.block_size = htonl(256);
	hdr.postheader_block = 3;
	hdr.postheader_size = 10;
	hdr.post_count = 0;
	hdr.firstpost_block = 0;
	hdr.lastpost_block = 0;
	hdr.next_id = 1;

	hdr.__x2 = htonl(1);
	hdr.__x3 = htonl(1);
	hdr.__x4 = htonl(1);
	hdr.__x5 = htonl(2);

	hdr.max_title_len = htonl(163);

	hdr.__x6 = 0;
	hdr.__x7 = 0;
	hdr.__x8 = 0;

	hdr.title_len = inFileName.size() > ntohl(hdr.max_title_len) ? ntohl(hdr.max_title_len) : inFileName.size();
	strncpy(hdr.title, inFileName.c_str(), ntohl(hdr.max_title_len));

	file.exceptions(ios::failbit);

	try
	{
		DEBUG_CALL(printf("file.seekp\n"));
		file.write((char*)&hdr, ntohl(hdr.block_size));
		DEBUG_CALL(printf("wrote header\n"));
		file.write(buffer, 256);
		buffer[0] = 0xC0;
		file.write(buffer, 256);
		buffer[0] = 0x00;
		file.write(buffer, 256);
		file.write(buffer, 10);
		DEBUG_CALL(printf("wrote buffers\n"));
		file.close();
	}
	catch (ios::failure &error)
	{
		return false;
	}

	return true;
}

#endif // CONFIG_THREADEDNEWS

