// This is used by HLTransfer for calculating transfer stats
// for HLClient when it needs to create information on a user

#if !defined(WIN32)
#include <sys/time.h>
#endif //!WIN32

class NetworkSpeed
{
	public:
		NetworkSpeed();

		void Start(unsigned int inTotalBytes);
        
        void StartSendTimer();
        
		void Update(unsigned int inTransferedBytes);
	
        void LimitSpeed(unsigned int inTransferedBytes, unsigned int inMaxBps);
	
		inline const double PercentageComplete() const //2003/11/03 modified by ortana.
		{                                                                                              
			double totalBytes = mTotalBytes;
			return ((mTransferedBytes / totalBytes) * 100.0);
		}

		unsigned int BytesPerSecond();
		
		inline unsigned const int EstimatedTimeRemaining()// in seconds
		{
            unsigned int bytesPerSecond = BytesPerSecond();
            if (bytesPerSecond == 0)
                return (unsigned int)-1;
            else
                return ((mTotalBytes - mTransferedBytes) / bytesPerSecond);
		}
		
		inline const unsigned int TotalBytes() const
			{ return mTotalBytes; }
			
		inline const unsigned int TransferedBytes() const
			{ return mTransferedBytes; }
		
		bool IsStalled();

	private:
		unsigned int mTotalBytes;
		unsigned int mTransferedBytes;
		struct timeval mStartTime;
        struct timeval mSendBeginTime;
		struct timeval mUpdateTime;
};

