#include "InspectSOCKS.h"

#if !defined(WIN32)
#include <sys/socket.h>
#include <arpa/inet.h>
#include <errno.h>
#include <unistd.h>
#endif // !WIN32

InspectSOCKSThread::InspectSOCKSThread(const string &inAddress, InspectSOCKSCallback &inCallback)
	: mAddress(inAddress), mCallback(inCallback)
{
}

InspectSOCKSThread::~InspectSOCKSThread()
{
}

void InspectSOCKSThread::Run()
{
	char req[9];
	char resp[100];
	int ver = 0;
	int read_bytes;
	struct sockaddr_in server;
	
	memset(&server, 0, sizeof(server)); /* zero the struct */
	server.sin_family = AF_INET; /* host byte order */
	server.sin_port = htons(1080); /* short, network byte order */
	
	DEBUG_CALL(printf("SOCKS test address: %s\n", mAddress.c_str()); fflush(stdout));
	if (!inet_aton(mAddress.c_str(), &server.sin_addr))
	{
		DEBUG_CALL(printf("invalid SOCKS IP/host\n"); fflush(stdout));
		return;
	}
	
	/* Now, we send a SOCKS V5 request which happens to be */
	/* the same size as the smallest possible SOCKS V4     */
	/* request. In this packet we specify we have 7 auth   */
	/* methods but specify them all as NO AUTH.            */
	memset(req, 0, sizeof(req));
	req[0] = '\x05';
	req[1] = '\x07';
	read_bytes = SendRequest(&server, req,
		sizeof(req), resp, sizeof(resp));
	if (read_bytes > 0)
	{
		if ((int) resp[0] == 0)
			ver = 4;
		else if ((int) resp[0] == 5)
			ver = 5;
		if (ver != 0)
		{
			mCallback.FoundSOCKSHost(mAddress, ver);
			//printf("Reply indicates server is a version "
			//       "%d socks server\n", ver);
		}
		else
		{
			//DEBUG_CALL("Invalid SOCKS version reply " <<
			//	ver << " probably not a socks server" << endl);
		}
		return;
	}	

	/* Hmmm.... disconnected so try a V4 request */
	//DEBUG_CALL("Server disconnected V5 request, trying V4" << endl);
	req[0] = '\x04';
	req[1] = '\x01';
	read_bytes = SendRequest(&server, req,
		sizeof(req), resp, sizeof(resp));	
	if (read_bytes > 0)
	{
		if ((int) resp[0] == 0)
			ver = 4;
		if (ver == 4)
		{
			mCallback.FoundSOCKSHost(mAddress, ver);
			//printf("Reply indicates server is a version "
			//       "4 socks server\n");
		}
		else
		{
			//DEBUG_CALL("Invalid SOCKS version reply " <<
			//	(int)resp[0] << " probably not a socks server" << endl);
		}
		return;
	}
	else
	{
		//DEBUG_CALL(
		//	"Server disconnected, probably not a socks server" << endl);
	}
	
	delete this;
}

int InspectSOCKSThread::SendRequest(struct sockaddr_in *server,
	void *req, int reqlen, void *rep, int replen)
{
	int sock;
	int rc;

	if ((sock = socket(server->sin_family, SOCK_STREAM, 0)) < 0)
	{
		DEBUG_CALL(printf("Could not create socket: %s\n", strerror(errno)); fflush(stdout));
		return -1;
	}
    
#if defined(SO_NOSIGPIPE)
    int on = 1;
	if (setsockopt(sock, SOL_SOCKET, SO_NOSIGPIPE, (void*)&on, sizeof(on)) == -1)
	{
		return -1;
	}
#endif
	
	if (connect(sock, (struct sockaddr *) server, sizeof(struct sockaddr_in)) != -1)
	{
		if (::send(sock, (netdata_t*) req, reqlen, MSG_NOSIGNAL) > 0)
		{
			if ((rc = ::recv(sock, (netdata_t *) rep, replen, 0)) > 0)
			{
				::closesocket(sock);
				return rc;
			}
			else
			{
				//DEBUG_CALL("Could not read from server " << strerror(errno) << endl);
			}
		}
		else
		{
			//DEBUG_CALL("Could not send to server " << strerror(errno) << endl);
		}
	}
	else
	{
		//DEBUG_CALL("Connect failed! " << strerror(errno) << endl);
	}	
	
	::closesocket(sock);

	return -1;
}

