#ifndef HL_TRANSFER_INFO
#define HL_TRANSFER_INFO

#include <string>
#include "HLUser.h"

enum TransferType
{
	kInvalidTransfer = -1,
	kDownloadTransfer = 0,
	kPreviewTransfer = 1,
	kUploadTransfer = 2
};

class HLTransferInfo
{
public:
	HLTransferInfo()
		: localDataForkSize(0), remoteDataForkSize(0),
		transferSize(0), type(kInvalidTransfer) {}

		inline const bool valid() const
		{ return type != kInvalidTransfer; }

		u_int32_t localDataForkSize;
		u_int32_t remoteDataForkSize;
		u_int32_t transferSize;
		string filePath;
		string fileName;
		HLUser user;
		TransferType type;
		u_int32_t ref;
};

#endif//HL_TRANSFER_INFO