#ifndef HL_NEWSFILE_H
#define HL_NEWSFILE_H 1

#include <string>
#include <fstream>

using namespace std;

namespace NewsFile
{

#ifdef WIN32
	// unique category identifier
	typedef struct {
		u_int32_t	time_low PACKED;
		u_int16_t	time_mid PACKED;
		u_int16_t	time_hi_and_version PACKED;
		u_int8_t	clock_seq_hi_and_reserved PACKED;
		u_int8_t	clock_seq_low PACKED;
		u_int8_t	node[6] PACKED;
	} uuid_tt;
#else
	typedef struct {
		u_int32_t	time_low PACKED;
		u_int16_t	time_mid PACKED;
		u_int16_t	time_hi_and_version PACKED;
		u_int8_t	clock_seq_hi_and_reserved PACKED;
		u_int8_t	clock_seq_low PACKED;
		u_int8_t	node[6] PACKED;
	} uuid_t;
#endif//WIN32

	// pointers to post maps
	typedef struct {
		u_int32_t	block PACKED;		/* location of post map */
		u_int32_t	count PACKED;		/* number of entries in post map */
	} map_t;

	// pointers to post info blocks
	typedef struct {
		u_int32_t	id PACKED;			/* thread id */
		u_int32_t	block PACKED;		/* location of post info */
	} pmap_t;

	// file header
	typedef struct {
		char		magic[8] PACKED;			/* 'HLNZ' and version 0x0002 */
#ifdef WIN32
		uuid_tt		uuid PACKED;				/* unique category id */
#else
		uuid_t		uuid PACKED;
#endif//WIN32
		u_int32_t	__x0 PACKED;				/* perhaps total post count */
		u_int32_t	__x1 PACKED;				/* constant 1 */
		u_int32_t	block_size PACKED;			/* size of data blocks in file */
		u_int32_t	postheader_block PACKED;	/* location of post headers */
		u_int32_t	postheader_size PACKED;		/* size in bytes of post headers */
		u_int32_t	post_count PACKED;			/* current number of posts */
		u_int32_t	firstpost_block PACKED;		/* location of first post (active or ever?) */
		u_int32_t	lastpost_block PACKED;		/* location of last post (active or ever?) */
		u_int32_t	next_id PACKED;				/* next thread id */
		u_int32_t	__x2 PACKED;				/* constant 1 */
		u_int32_t	__x3 PACKED;				/* constant 1 */
		u_int32_t	__x4 PACKED;				/* constant 1 */
		u_int32_t	__x5 PACKED;				/* constant 2 */
		u_int32_t	max_title_len PACKED;		/* maximum category title length */
		/*   max 0xA3 for 256 bytes file header */
		u_int32_t	__x6 PACKED;				/* constant 0 */
		u_int32_t	__x7 PACKED;				/* constant 0 */
		u_int32_t	__x8 PACKED;				/* constant 0 */
		u_int8_t	title_len PACKED;			/* length of category title */
		char		title[163] PACKED;			/* category title */
	} file_hdr_t;

	// post info
	typedef struct {
		u_int32_t	postdata_block PACKED;	/* location of post data */
		u_int32_t	__x0 PACKED;			/* unknown (0xC0) */
		u_int8_t	mimetype_len PACKED;	/* length of post's mime type */
		char		mimetype[27] PACKED;	/* mime type of post*/
		u_int32_t	id PACKED;				/* thread id */
		u_int32_t	previous_id PACKED;		/* id of previous thread */
		u_int32_t	next_id PACKED;			/* id of next thread */
		u_int32_t	parent_id PACKED;		/* id of parent thread */
		u_int32_t	reply_id PACKED;		/* id of first reply */
		u_int32_t	date_base PACKED;		/* base year of creation date */
		u_int32_t	date_sec PACKED;		/* seconds since base year */
		u_int32_t	__x1 PACKED;			/* constant 0 */
		u_int8_t	title_len PACKED;		/* length of post title */
		char		title[63] PACKED;		/* post title */
		u_int8_t	author_len PACKED;		/* length of author name */
		char		author[31] PACKED;		/* author name */
		u_int8_t	email_len PACKED;		/* length of email address (or uuid) */
		char		email[91] PACKED;		/* email address */
	} post_info_t;

	// post data
	typedef struct {
		u_int32_t	__x0 PACKED;			/* constant 0 */
		u_int32_t	data_len PACKED;		/* length of data */
		u_int8_t	mimetype_len PACKED;	/* length of data's mime type */
		char		mimetype[11] PACKED;	/* mime type of data */
		char		data[ZERO_SIZE_ARRAY_SIZE] PACKED;	/* data */
	} post_data_t;

	//post headers
	typedef struct {
		u_int32_t	__x0 PACKED;			/* constant 0 */
		u_int32_t	count PACKED;			/* thread count */
		u_int16_t	__x1 PACKED;			/* constant 0 */
		char		headers[ZERO_SIZE_ARRAY_SIZE] PACKED;	/* post headers */
	} post_hdr_t;

	//post header entry
	typedef struct {
		u_int32_t	id PACKED;				/* thread id */
		u_int32_t	date_base PACKED;		/* base year of creation date */
		u_int32_t	date_sec PACKED;		/* seconds since base year */
		u_int32_t	parent_id PACKED;		/* id of parent thread */
		u_int32_t	__x0 PACKED;			/* constant 0 */
		u_int16_t	element_count PACKED;	/* constant 1 (element count, always 1) */
		char		elements[ZERO_SIZE_ARRAY_SIZE] PACKED; /* element data, see below */
		// the following fields are for reference only!
#if 0
		u_int8_t	title_len;				/* length of post title */
		char		title[];				/* post title */
		u_int8_t	author_len;				/* length of author */
		char		author[];				/* author */
		u_int8_t	mimetype_len;			/* length of mime type */
		char		mimetype[];				/* mime type ("text/plain") */
		u_int16_t	data_len;				/* length of post data */
#endif
	} post_hdr_entry_t;



/*----------------------------------------------------------------------------------//

	HLNewsFile

	Xbhj[Xt@C̑Bt@C\NX


//---------------------------------------------------------------------------------*/

	class HLNewsFile
	{
	public:
		HLNewsFile();
		HLNewsFile(const string &inPath);
		~HLNewsFile();

		bool Open(const string &inPath);
		void Close();
		void Clear();

		bool FileValid();
		bool UpdateHeader();
		bool UpdateMainMap();
		bool UpdateUnknownBlocks(); // yeah d:D --jcb
		bool WritePostHeaders();
		bool ReadPostHeaders();
		u_int32_t WriteBlocks(u_int32_t inBlockNum, const void* inData, u_int32_t inDataSize);
		u_int32_t WritePostInfo(u_int32_t block, post_info_t postinfo);
		u_int32_t WritePostData(u_int32_t block, post_data_t &data);
		bool ReadBlocks(u_int32_t inBlockNum, void* outData, u_int32_t inDataSize);
		u_int32_t	BlockSize();
		file_hdr_t*	GetHdr();

		post_hdr_t*	mPostHeaders;
		map_t*		mMainMap;
		pmap_t*		mPostMap; // this is just a buffer guaranteed large enough to hold any post map in the file
		fstream		mFile;

	private:
		file_hdr_t	mHdr;
		bool		mValid;
	};
}
#endif // HL_NEWSFILE_H
