// HLClient holds data about a client connected to the server
// It handles processing and sending all packets for that client
// Each client runs in its own thread, but I might change that

#ifndef HL_CLIENT_H
#define HL_CLIENT_H

#include "HLSocket.h"
#include "AsyncDNS.h"

class HLUser;
class HLServer;
#include "HLUser.h"
#include "HLServer.h"

#ifdef WIN32
class Command;
#endif//WIN32

#define CHAT_LIMIT				(1024 * 2)
#define POST_LIMIT				(1024 * 10)
#define MAX_CHATSFORSERVER		50
#define MAX_CHATSFORCLIENT		5
#define FLOOD_INTERVAL			2
#define FLOOD_LIMIT				10

const string kBanReasonBot = "being a bot";
const string kBanReasonStealingAdminsName = "stealing an admin's name";
const string kBanReasonSOCKSv4 = "using a SOCKSv4 proxy";
const string kBanReasonSOCKSv5 = "using a SOCKSv5 proxy";
const string kBanReasonLeech = "being a leech";
const string kBanReasonStrikes = "being kicked too many times";

class HLChat;

class HLClient : public HLSocketCallback, public AsyncDNSCallback
{
public:
#if defined(CONFIG_LINKING)
	// constructor for remote users
	HLClient(const string &inName, u_int32_t inGlobalID, u_int16_t inIcon,
		u_int16_t inStatus, HLAccount &inAccount);
#endif

	// constructor for local users
	HLClient(HLSocket *inSocket);

	// this doesn't need to be virtual, but it gets rid of a gcc warning
	virtual ~HLClient();

	bool IsConnected();

	void Disconnect();
	void Ban(const HLUser &inUser, const string &inReason = "",
		const u_int32_t inTimeout = 0);
	u_int32_t RemoteHost();
	const string &Hostname() const
	{ return mHostname; }
	void SendKeepAlive();
	void SendPacket(HLPacket &inPacket)
	{
		if (mSocket)
			mSocket->SendPacket(inPacket);
	}
	void SendSelfInfo(bool inFakeFilePrivs = false);
	void SendTaskError(const string &inError, u_int32_t inID);

	bool AddChatInvite(HLChat &inChat);
	bool RemoveChatInvite(HLChat &inChat);

	HLUser &User()
	{ return mUser; }

	const string Address() const;
	void Cleanup();

	bool IsRemote()
	{ return (mSocket == NULL); }

protected:
	void NameLookup(const string &inHost, const string &inName);
	void OnClose();
	void HandlePacket(HLPacket &inPacket);

	void SendChatGreeting();
	bool ParseAccountModify(HLObjectList &inList, bool inCanCreate);
	void ParseAccountDelete(HLObjectList &inList);

	void ProcessPacket(HLPacket &inPacket);
	void HandleLogin(HLPacket &inPacket);
	void HandleUserGetList(HLPacket &inPacket);
	void HandleUserChange(HLPacket &inPacket);
	void HandleUserKick(HLPacket &inPacket);
	void HandleUserGetInfo(HLPacket &inPacket);
	void HandleNewsGetFile(HLPacket &inPacket);
	void HandleNewsPost(HLPacket &inPacket);
	void HandleMessage(HLPacket &inPacket);
	void HandleChat(HLPacket &inPacket);
	void HandleChatSubject(HLPacket &inPacket);
	void HandleChatCreate(HLPacket &inPacket);
	void HandleChatInvite(HLPacket &inPacket);
	void HandleChatDecline(HLPacket &inPacket);
	void HandleChatJoin(HLPacket &inPacket);
	void HandleChatPart(HLPacket &inPacket);
	void HandleFileList(HLPacket &inPacket);
	void HandleFileDelete(HLPacket &inPacket);
	void HandleFileMkDir(HLPacket &inPacket);
	void HandleFileGetInfo(HLPacket &inPacket);
	void HandleFileSetInfo(HLPacket &inPacket);
	void HandleFileMove(HLPacket &inPacket);
	void HandleFileSymLink(HLPacket &inPacket);
	void HandleFileGet(HLPacket &inPacket);
	void HandleFilePut(HLPacket &inPacket);
	void HandleAccountCreate(HLPacket &inPacket);
	void HandleAccountDelete(HLPacket &inPacket);
	void HandleAccountRead(HLPacket &inPacket);
	void HandleAccountModify(HLPacket &inPacket);
	void HandleAccountList(HLPacket &inPacket);
	void HandleAccountListModify(HLPacket &inPacket);
	void HandlePing(HLPacket &inPacket);
	void HandleBroadcast(HLPacket &inPacket);
	void HandleTransferStop(HLPacket &inPacket);
	void HandleFolderGet(HLPacket &inPacket);
	void HandleFolderPut(HLPacket &inPacket);
#if defined(CONFIG_THREADEDNEWS)
	void HandleNewsDirList(HLPacket &inPacket);
	void HandleAgreementAgree(HLPacket &inPacket);
	void HandleNewsCatList(HLPacket &inPacket);
	void HandleNewsGetThread(HLPacket &inPacket);
	void HandleNewsMkDir(HLPacket &inPacket);
	void HandleNewsDeleteCatDir(HLPacket &inPacket);
	void HandleNewsMkCat(HLPacket &inPacket);
	void HandleNewsPostThread(HLPacket &inPacket);
#endif // CONFIG_THREADEDNEWS

private:
	HLSocket *mSocket;

	string mHostname;
	u_int16_t mVersion;
	HLUser mUser;
	time_t mLastPacketTime;
	ChatList mChatInviteList;
	u_int32_t mLeechCounter;
	u_int8_t mFloodCounter;
	bool mListedFiles;
	
#ifdef WIN32
	Command *cmd;
	void SendPMGreeting();
#endif//WIN32
};

#endif // HL_CLIENT_H


