#ifndef FILE_UTILS_H
#define FILE_UTILS_H
// A namespace of utility functions mainly dealing with files
// mostly used by HLClient and HLTransfer

#if defined(_PREFPANE_)
#include <string>
#include <CoreServices/CoreServices.h>

using namespace std;

namespace FileUtils
{
	bool deletePath(const string &inPath);

#if defined(_CARBON_)
	void FSRefToPath(const FSRef inRef, string &outPath);
	bool PathToFSRef(const string &inPath, FSRef *outRef);
	void resolveAlias(string &ioPath);
#endif
}

#else // defined(_PREFPANE_)

#if !defined(WIN32)
#include <sys/time.h>
#else//2003/07/21 added by ortana.
#include <shlobj.h>
#include <Shlwapi.h>
#endif//!WIN32

#include <string>
#include <map>
#include "HLUser.h"
#include "HLPacket.h"

#if defined(_CARBON_)
#include <CoreServices/CoreServices.h>
#endif

// these defined are to get rid of warnings
// from gcc about multicharacter constants (aka bullshit)
#define UNKNOWN_TYPE			0x3F3F3F3F // '????'
#define ALIAS_TYPE			0x616C6973 // 'alis'
#define DIR_TYPE			0x666C6472 // 'fldr'
#define FILE_TRANSFER_TYPE		0x48546674 // 'HTft'
#define JPEG_TYPE			0x4A504547 // 'JPEG'
#define MPEG_TYPE			0x4D504547 // 'MPEG'
#define MOOV_TYPE			0x4D6F6F56 // 'MooV'
#define GIF_TYPE			0x47494666 // 'GIFf'
#define PNG_TYPE			0x504E4766 // 'PNGf'
#define PICT_TYPE			0x50494354 // 'PICT'
#define MP3_1_TYPE			0x4D703320 // 'Mp3 '
#define MP3_2_TYPE			0x4D503320 // 'MP3 '
#define MP3_3_TYPE			0x4D504733 // 'MPG3'
#define WAV_1_TYPE			0x2E574156 // '.WAV'
#define WAV_2_TYPE			0x57415645 // 'WAVE'
#define AVI_TYPE			0x56665720 // 'VfW '
#define SIT4_TYPE			0x53495444 // 'SITD'
#define SIT5_TYPE			0x53495435 // 'SIT5'
#define GZIP_TYPE			0x477A6970 // 'Gzip'
#define ZIP_TYPE			0x5A495020 // 'ZIP '
#define RTF_TYPE			0x52544620 // 'RTF '
#define PDF_TYPE			0x50444620 // 'PDF '
#define PSD_TYPE			0x38425053 // '8BPS'

#define UNKNOWN_CREATOR			UNKNOWN_TYPE
#define QUICKTIME_CREATOR		0x54564F44 // 'TVOD'
#define STUFFIT_CREATOR			0x53495421 // 'SIT!'
#define TEXTEDIT_CREATOR		0x74747874 // 'ttxt'
#define HOTLINE_CREATOR			0x48544C43 // 'HTLC'
#define ACROBAT_CREATOR			0x4341524F // 'CARO'
#define PHOTOSHOP_CREATOR		0x3842494D // '8BIM'

using namespace std;

typedef multimap< u_int32_t, string > FileTypeExtensionMap;
typedef map< u_int32_t, u_int32_t > FileTypeCreatorMap;

namespace FileUtils
{
	void Init();
	void createTypeMaps();
	void fixLineEndings(string &ioString);
	bool PathVectorToRealPath(const string &inRootPath,
		const PathVector &inPathVector, string &outRealPath);
	bool deletePath(const string &inPath);
	bool movePath(const string &inFromPath,
		const string &inToPath, const string &inFileName);
	u_int32_t creatorForType(const u_int32_t inType);
	u_int32_t fileTypeFromName(const string &inFileName);
	void postProcessUpload(const string &inFilePath, u_int32_t inType);
	bool checkUploadPathAndResumeSize(const string &inPath,
		const string &inName, string &outFullPath, u_int32_t &outLocalDataForkSize);
	bool getFileExtension(const string &inPath, string &outExtension);

	void formatSize(u_int64_t inBytes, string &outSizeString);
	void formatTime(unsigned int inSeconds, string &outTimeString);
	int copy_and_unlink(const string &inFrom, const string &inTo);
	bool noCaseCompare(const string &s1, const string &s2);
	bool noCaseStrStr(const string &s1, const string &s2);

	bool canUserAccessPath(const HLUser &inUser, const PathVector &inUploadPathVector,
		bool &outIsDropBoxesDir, bool &outIsUsersDropBox);
	bool isValidUploadPath(const PathVector &inUploadPathVector);

	bool addFileInfoToPacket(const string &inPath, const string &inFileName, HLPacket &ioPacket);
	void scanPathToPacket(const string &inPath, HLPacket &ioPacket);

	void removeExtension(string &ioFilePath);

	void HomeToNetworkString(string &ioString);
	void NetworkToHomeString(string &ioString);


	//2003/07/21 added by ortana.
#if defined(WIN32)

	void getAbsolutePath(const string &inPath, char * buff );
	HRESULT getShortcutLink(const LPSTR pszLink, LPSTR pszFilePath, 
		int cchMaxPath, WIN32_FIND_DATA *wfd);
	BOOL resolve_Link(LPSTR sourcePath ,const LPSTR linkPath);
	BOOL CreateShellLink( const char *LinkFile, const char *TargetFile, const char *Arguments, const char *WorkDir, int ShowCmd );
	BOOL getFileTime(const string& filePath , char *createdTime , char *modifiedTime);
	const BOOL IsExistObject(const LPCTSTR lpszFileName,const BOOL bDirectory);
	int countAllFile(const char * dirPath );
	void LoadText(const string& inPath,string& outText);
	void SaveText(const string& inPath ,string& inOutText);

#endif//WIN32


#if defined(_CARBON_)
	void FSRefToPath(const FSRef inRef, string &outPath);
	bool PathToFSRef(const string &inPath, FSRef *outRef);
	void resolveAlias(string &ioPath);
#endif
}

#endif // defined(_PREFPANE_)

#endif // FILE_UTILS_H

