#if defined(CONFIG_RENDEZVOUS)

#include "DNSServiceRegistrar.h"

RegisteredServicesList DNSServiceRegistrar::mRegisteredList;
BMutex DNSServiceRegistrar::mLock;
BCondition *DNSServiceRegistrar::mCondition = NULL;
CFRunLoopRef DNSServiceRegistrar::mRunLoop = NULL;

static void handleMachMessage(CFMachPortRef /*port*/, void *msg, CFIndex /*size*/, void */*info*/)
{
    DNSServiceDiscovery_handleReply(msg);
}

DNSServiceRegistrar::DNSServiceRegistrar()
{
    if (mRunLoop == NULL)
    {
        mCondition = new BCondition();
        Create();
        mCondition->Wait(1, 0);
        delete mCondition;
        mCondition = NULL;
    }
}

DNSServiceRegistrar::~DNSServiceRegistrar()
{
}

void DNSServiceRegistrar::RegisterService(const string &inServiceName, const string &inServiceType,
            const string &inServiceDomain, const u_int16_t inServicePort,
            DNSServiceRegistrarCallback *inCallback)
{
    mach_port_t port;
    ServiceRecord *serviceRecord = new ServiceRecord();
    serviceRecord->serviceName = inServiceName;
    serviceRecord->serviceType = inServiceType;
    serviceRecord->serviceDomain = inServiceDomain;
    serviceRecord->servicePort = inServicePort;
    serviceRecord->callback = inCallback;
    serviceRecord->dnsClient = DNSServiceRegistrationCreate(inServiceName.c_str(),
        inServiceType.c_str(), inServiceDomain.c_str(), inServicePort,
        "" /* don't use the evil text record! */,
        (DNSServiceRegistrationReply)DNSServiceRegistrar::PrivateRegisterReply, serviceRecord);
    port = DNSServiceDiscoveryMachPort(serviceRecord->dnsClient);
    if (port)
    {
        CFRunLoopSourceRef rls;
        CFMachPortRef cfMachPort;
        CFMachPortContext context;
        Boolean shouldFreeInfo;
        
        context.version = 1;
        context.info = 0;
        context.retain = NULL;
        context.release = NULL;
        context.copyDescription = NULL;
    
        cfMachPort = CFMachPortCreateWithPort(kCFAllocatorDefault, port,
            (CFMachPortCallBack)handleMachMessage, &context, &shouldFreeInfo);

        rls = CFMachPortCreateRunLoopSource(NULL, cfMachPort, 0);
        
        {
            StMutexLock lock(mLock);
            mRegisteredList.push_back(serviceRecord);
            CFRunLoopAddSource(mRunLoop, rls, kCFRunLoopDefaultMode);
        }
        
        CFRelease(rls);
    }
    else
    {
        DEBUG_CALL(printf("DNSServiceRegistrar::RegisterService could not obtain client mach port\n"));
    }
}

void DNSServiceRegistrar::UnregisterService(const string &inServiceName)
{
    StMutexLock lock(mLock);
    RegisteredServicesList::iterator iter = mRegisteredList.begin();
    while (iter != mRegisteredList.end())
    {
        if ((*iter)->serviceName == inServiceName)
        {
            dns_service_discovery_ref ref = (*iter)->dnsClient;
            if (ref)
                DNSServiceDiscoveryDeallocate(ref);
            mRegisteredList.erase(iter);
            return;
        }
        iter++;
    }
    /*
    RegisteredServicesMap::iterator iter = mRegisteredMap.find(inServiceName);
    if (iter != mRegisteredMap.end())
    {
        dns_service_discovery_ref ref = (dns_service_discovery_ref)iter->second;
        if (ref)
        {
            DNSServiceDiscoveryDeallocate(ref);
            mRegisteredMap.erase(inServiceName);
        }
    }
    */
}

void DNSServiceRegistrar::PrivateRegisterReply(int inErrorCode, void *inContext)
{
    StMutexLock lock(mLock);
    ServiceRecord *serviceRecord = (ServiceRecord *)inContext;
    RegisteredServicesList::iterator iter = mRegisteredList.begin();
    while (iter != mRegisteredList.end())
    {
        // make sure the service record is still in the list
        if ((*iter) == serviceRecord)
        {
            if (serviceRecord->callback)
            {
                serviceRecord->callback->RegisterReply(serviceRecord->serviceName, inErrorCode);
                return;
            }
        }
        iter++;
    }
    
    DEBUG_CALL(printf("serviceRecord not found for: %s %d\n", serviceRecord->serviceName.c_str(), inErrorCode));
}

void DNSServiceRegistrar::Run()
{
    mCondition->Signal(1);
    // store the run loop so we can add sources to it
    mRunLoop = CFRunLoopGetCurrent();
    CFRunLoopTimerRef timer = CFRunLoopTimerCreate(kCFAllocatorDefault,
    0.0, 500.0, 0, 0,	// Next fire time, periodic interval, flags, and order
                        dumbyTimer, NULL);
    CFRunLoopAddTimer(CFRunLoopGetCurrent(), timer, kCFRunLoopDefaultMode);
    CFRunLoopRun();
    CFRelease(timer);
}

void DNSServiceRegistrar::dumbyTimer(CFRunLoopTimerRef, void *)
{
    // the timer function does nothing
    // it is only here to keep the run loop from exiting
}

#endif // CONFIG_RENDEZVOUS

