// Wrapper for pthread conditional variable.

#ifndef CONDITION_H
#define CONDITION_H

#if defined(USE_PTHREADS)
#include <pthread.h>
#elif defined(USE_WIN32THREADS)
#include "BMutex.h"
#endif // USE_PTHREADS

class BCondition
{
public:
	BCondition(int inValue = 0);
	~BCondition();
	
	void Wait(int inWaitValue, int inSetValue);
	bool TimedWait(int inWaitValue, int inSetValue, int inTimeout);
	void Signal(int inValue);
	
protected:
	int mValue;
#if defined(USE_WIN32THREADS)
	HANDLE mSemHandle;
	BMutex mMutex;
#elif defined(USE_PTHREADS)
	pthread_mutex_t mMutex;
	pthread_cond_t mCond;
#endif // USE_PTHREADS
};

#endif // CONDITION_H


