// Reads in the conf file and holds configuration information
// that is accessed by HLServer

#ifndef SERVERCONF_H
#define SERVERCONF_H

#include <list>
#include <string>
#include <stdexcept>

using namespace std;

struct TrackerEntry
{
    TrackerEntry(const string &inAddr, const string &inPass)
        : addr(inAddr), pass(inPass) {}
    string addr;
    string pass;
};
typedef struct TrackerEntry TrackerEntry;

typedef list<TrackerEntry> TrackerList;

struct ServerConf
{
	ServerConf();
	
	bool ReadConf(const char *inConfFile) throw (runtime_error);
	bool WriteConf(const char *inConfFile);
	void ReloadConf();
	
	long dirPermissions;
	long filePermissions;
	u_int32_t maxDownloads;
	u_int32_t maxUploads;
	u_int32_t maxUsers;
	u_int32_t maxClientsPerAddress;
	time_t idleTimeout;
	time_t banTimeout;
	string serverName;
	string serverDescription;
	u_int16_t serverPort;
	u_int16_t serverVersion;
	bool databaseReadOnly;
	string databaseAddress;
	string databaseUser;
	string databasePassword;
	string databaseName;
	string rootPath;
	string agreementPath;
	string newsPath;
	string newsDirPath;
	string accountsPath;
	string logsPath;
	TrackerList trackerList;
	u_int8_t socksDetectLevel;
	string textEncoding;
	uid_t userID;
	gid_t groupID;
	string linkServer;

	string confFile;
};

#endif // SERVERCONF_H


