#if defined(CONFIG_THREADEDNEWS)

#include "NewsUtils.h"
#include "FileUtils.h"
#include <fcntl.h>
#ifndef WIN32
#include <dirent.h>
#include <unistd.h>
#include <sys/errno.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <sys/param.h>
#endif//!WIN32
#include <stdlib.h>
#include "dirchar.h"

/* 	These functions handle reading/writing of file-based threaded news.
I would imagine that HLDatabase should handle generic news functions,
calling functions in NewsUtils when a file-based news implementation
is used as opposed to a database implementation. -- jcb */

using namespace NewsUtils;
using namespace FileUtils;

void NewsUtils::scanPathToPacket(const string &inPath, HLPacket &ioPacket)
{
	char hdrDataBuf[SIZEOF_HL_BUNDLELIST_BUNDLE_HDR + 255];

	// should this be done in a better way? yes - jcb
	// bundles and categories have only ntype and count in common
	struct hl_bundlelist_bundle_hdr		*bundleHdr = (struct hl_bundlelist_bundle_hdr *)hdrDataBuf;
	struct hl_bundlelist_category_hdr	*categoryHdr = (struct hl_bundlelist_category_hdr *)hdrDataBuf;

	u_int16_t ntype = 0;
	struct dirent *de;
	struct stat sb;


#ifdef WIN32
	char sPath[MAX_PATH];
	FileUtils::getAbsolutPath( inPath.c_str() , sPath );
	string filePath( sPath );
	string rootPath( sPath );
	sprintf( sPath , "%s*" , sPath );//or"%s\\*" ??
	WIN32_FIND_DATA FindFileData;
	HANDLE  hDir = FindFirstFile( sPath , &FindFileData );
	if( hDir == INVALID_HANDLE_VALUE )
	{
		return;
	}


	do{//------------do while----------//
		if( FindFileData.cFileName[0] == '.' ||
			(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) ||
			(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) )
		{
			continue;
		}

		//		WIN32_FIND_DATA FindFileData;
		filePath.assign(rootPath);
		string fileName(FindFileData.cFileName);
		filePath.append( fileName );//or filename only?


		if( GetDriveType( fileName.c_str() ) > 1 )//drive
		{
			FindFileData.dwFileAttributes = 17;
			filePath.append("*");

			bundleHdr->ntype = ntype = 2;
			bundleHdr->count = htonl(FileUtils::countAllFile( filePath.c_str() ));
		}
		else if(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )//folder
		{
			filePath.append("\\*");

			bundleHdr->ntype = ntype = 2;
			bundleHdr->count = htonl(FileUtils::countAllFile( filePath.c_str() ));

		}
		else//file
		{
#else




	DIR *dir;


	dir = opendir(inPath.c_str());
	if (dir == NULL)
	{
		return;
	}

	while ((de = readdir(dir)) != NULL)
	{
		//bool isLink = false;
		bool isValid = true;
		string fileName(de->d_name);

		if (fileName[0] != '.')
		{
			string filePath(inPath);
			filePath.append(fileName);

#if defined(_CARBON_)
			resolveAlias(filePath);
			FSRef theRef;
			if (PathToFSRef(filePath, &theRef))
			{
				FSCatalogInfo catInfo;
				if (FSGetCatalogInfo(&theRef, kFSCatInfoFinderInfo,
					&catInfo, NULL, NULL, NULL) == noErr)
				{
					FInfo *finderInfo = (FInfo *)catInfo.finderInfo;
					if (finderInfo->fdFlags & kIsInvisible)
					{
						isValid = false;
					}
				}
				else
					isValid = false;
			}
			else
				isValid = false;
#endif // _CARBON_

			if (isValid)
			{
				if (lstat(filePath.c_str(), &sb) == 0)
				{
					if (S_ISDIR(sb.st_mode))
					{
						bundleHdr->ntype = ntype = 2;
						// count sub items
						DIR *subDir = opendir(filePath.c_str());
						u_int32_t subItemCount = 0;
						if (subDir)
						{
							struct dirent *subDe;
							while ((subDe = readdir(subDir)) != NULL)
							{
								string subFileName(subDe->d_name);
								if (subFileName[0] != '.')
									subItemCount++;
							}
							closedir(subDir);
						}
						bundleHdr->count = htonl(subItemCount);
					}
					else//file
					{
#endif//WIN32
						main_hdr_block	catHdr;

						ifstream file(filePath.c_str(), ios::in | ios::binary);
						// throw exceptions for all errors
						file.exceptions(ios::eofbit | ios::failbit | ios::badbit);
						if (getFileHeader(file, catHdr))
						{
							categoryHdr->ntype = ntype = 3;
							categoryHdr->count = catHdr.post_count;
							//this is horrible.. fix this...
							memcpy(categoryHdr->junk, &catHdr.uuid, sizeof(uuid_t));
							categoryHdr->count2 = categoryHdr->count + 1; // fun
							categoryHdr->unknown = 1; // this is always 1

						}
					}//file
#ifndef WIN32
				}//lstat
#endif//!WIN32

				HomeToNetworkString(fileName);

				if (ntype == 2)
				{
#ifdef WIN32
					bundleHdr->ntype = htons((u_int16_t)2);
					bundleHdr->nlen = fileName.length();
#else
					bundleHdr->nlen = htonl((u_int32_t)fileName.length());
#endif//WIN32
					memcpy(bundleHdr->name, fileName.c_str(), fileName.length());
					ioPacket.AddObject(HTLS_DATA_NEWS_BUNDLELIST,
						SIZEOF_HL_BUNDLELIST_BUNDLE_HDR + fileName.length(), (char *)bundleHdr);
				}
				else
				{
#ifdef WIN32
					bundleHdr->ntype = htons((u_int16_t)3);
					bundleHdr->nlen = fileName.length();
#else
					bundleHdr->nlen = htonl((u_int32_t)fileName.length());
#endif//WIN32
					memcpy(categoryHdr->name, fileName.c_str(), fileName.length());
					ioPacket.AddObject(HTLS_DATA_NEWS_BUNDLELIST,
						SIZEOF_HL_BUNDLELIST_CATEGORY_HDR + fileName.length(), (char *)categoryHdr);
				}
#ifndef WIN32
			}//isValid
#else
			} while(FindNextFile(hDir, &FindFileData));//------------do while----------//
#endif
#ifndef WIN32

		}//fileName[0]
		//}
	}//While.... stupid nest.
	closedir(dir);
#endif
}

bool NewsUtils::getFileHeader(istream &inFile, main_hdr_block &outHdr)
{
	u_int8_t	magic[8];
	// save the stream position
	streampos savedPos = inFile.tellg();

	inFile.seekg(0, ios::beg);
	inFile.read((char *)&magic, sizeof(magic));
	if (memcmp(magic, HLNZ_MAGIC, 8) != 0)
		return false;	//not a valid news file (at least one we recognize d:P)

	DEBUG_CALL(printf("valid news file\n"));

	inFile.seekg(0, ios::beg);
	inFile.read((char *)&outHdr, sizeof(main_hdr_block));
	DEBUG_CALL(printf("returning true\n"));

	// return stream position
	inFile.seekg(savedPos, ios::beg);

	return true;
}

bool NewsUtils::setFileHeader(ostream &inFile, const main_hdr_block &inHdr)
{
	streampos savedPos = inFile.tellp();

	inFile.seekp(0, ios::beg);
	inFile.write((char*)&inHdr, sizeof(main_hdr_block));
	inFile.seekp(savedPos, ios::beg);

	return true;
}

bool NewsUtils::addPost(const string &inPath, u_int32_t inParentID, const string &inTitle, const string &inAuthor, const char *inPostData, u_int16_t inPostDataLen)
{
	fstream		file(inPath.c_str(), ios::in | ios::out | ios::binary);
	main_hdr_block	hdr;

	printf("%s\n", inPath.c_str());

	u_int8_t *postheaders = NULL;

	map_t 	*mainmap;
	int 	mainmap_count;

	//u_int32_t size;

	char nulls[1024];
	memset(nulls, 0, 1024);

	p_map_t	*postmap = NULL;
	int postmap_count;
	u_int32_t postmap_loc;

	post_info_block postinfo;
	u_int32_t postinfo_loc;

	post_data_block *postdata = NULL;
	u_int8_t *postdata_buf = NULL;
	u_int32_t postdata_loc;

	u_int32_t offset;


	if (getFileHeader(file, hdr) == false)
		return false;

	if (hdr.num_objects > 0)
	{
		postheaders = (u_int8_t*) malloc(hdr.quick_send_len);
		file.seekg((1 + hdr.num_objects) * hdr.block_size, ios::beg);
		file.read((char*)postheaders, hdr.quick_send_len);
		file.clear();
	}
	// we have now saved the post headers

	// get the main map
	mainmap = (map_t*)malloc(hdr.block_size);
	mainmap_count = hdr.block_size / sizeof(map_t);
	file.seekg((1 + 2) * hdr.block_size, ios::beg);
	file.read((char*)mainmap, hdr.block_size);


	// find the postmap to add the post to
	int n;
	int bestmap = 1;

	for(int i = 0; i < mainmap_count; i++)
	{
		n = (i == mainmap_count) ? 0 : i;
		if (mainmap[n].map_count < mainmap[bestmap].map_count)
			bestmap = n;
	}

	// figure out where we are supposed to write to and figure out the offset to that loc
	if (hdr.num_objects == 0) // headers dont exist
	{
		file.seekp(0, ios::end);
	}
	else // they do exist
	{
		printf("seeking to: %u\n", (1 + hdr.num_objects) * hdr.block_size);
		file.seekp((1 + hdr.num_objects) * hdr.block_size, ios::beg);
		printf("position: %u, state: %u\n", (unsigned int)file.tellp(), file.rdstate());
	}
	offset = file.tellp() / hdr.block_size - 1; // remember the offset


	if (mainmap[bestmap].block_offset == 0) // post map doesnt exist
	{
		postmap = (p_map_t*)malloc(hdr.block_size);
		postmap_count = 0;
		postmap_loc = offset;
		offset++; // increase offset by one because a new postmap only takes 1 block
	}
	else if ( (mainmap[bestmap].map_count != 0) && ((mainmap[bestmap].map_count * sizeof(p_map_t)) % hdr.block_size == 0)) // map is full
	{
		postmap_count = mainmap[bestmap].map_count;
		postmap = (p_map_t*)malloc((postmap_count + 1) * sizeof(p_map_t));
		postmap_loc = mainmap[bestmap].block_offset;
		file.seekg((1 + postmap_loc) * hdr.block_size, ios::beg);
		file.read((char*)postmap, sizeof(p_map_t) * postmap_count);
		postmap_loc = offset;
		offset += ((postmap_count + 1) * sizeof(p_map_t) - 1) / hdr.block_size + 1;
	}
	else // map already exists and is not full
	{
		postmap_count = mainmap[bestmap].map_count;
		postmap = (p_map_t*)malloc((postmap_count + 1) * sizeof(p_map_t));
		postmap_loc = mainmap[bestmap].block_offset;
		file.seekg((1 + postmap_loc) * hdr.block_size, ios::beg);
		file.read((char*)postmap, sizeof(p_map_t) * postmap_count);
	}

	printf("state: %u\n", file.rdstate());

	printf("read postmap\n");

	postinfo_loc = offset;
	offset ++;

	postdata_loc = offset;
	postdata_buf = (u_int8_t*)malloc((sizeof(post_data_block) + inPostDataLen));
	postdata = (post_data_block*)postdata_buf;

	printf("malloc'd postdata_buf\n");

	postdata->unknown = 0;
	postdata->post_len = inPostDataLen;
	postdata->mime_len = 10;
	strncpy((char*)postdata->mime, "text/plain", 11);
	strncpy((char*)postdata->post_text, inPostData, postdata->post_len);

	printf("set postdata\n");

	postinfo.data_offset = postdata_loc;
	postinfo.unknown01 = 0xC0;
	strncpy((char*)postinfo.mime_type, "application/x-hlnewsitem", 27);
	postinfo.mime_type_len = strlen("application/x-hlnewsitem");
	postinfo.internal_id = hdr.flag9;
	postinfo.previous_thread = 0;
	postinfo.next_thread = 0;
	postinfo.parent_thread = inParentID;
	postinfo.reply_thread = 0;
	postinfo.date.base = 1904;
	postinfo.date.sec = 0;
	postinfo.unknown02 = 0;
	postinfo.post_title_len = inTitle.length();
	strncpy((char*)postinfo.post_title, inTitle.c_str(), 63);
	postinfo.author_len = inAuthor.length();
	strncpy((char*)postinfo.author, inAuthor.c_str(), 31);
	postinfo.post_uuid_len = strlen("http://terra.berkleyidiots.com");
	strncpy((char*)postinfo.post_uuid, "http://terra.berkleyidiots.com", 91);

	printf("set postinfo\n");
	printf("state: %u\n", file.rdstate());
	// update the mainmap
	mainmap[bestmap].map_count++;
	mainmap[bestmap].block_offset = postmap_loc;

	// update the postmap
	postmap[postmap_count].id = hdr.flag9;
	postmap[postmap_count].offset = postinfo_loc;
	postmap_count++;

	printf("updated maps\n");

	file.fill(0);
	file.width(hdr.block_size);

	printf("state: %u\n", file.rdstate());
	// write the mainmap
	file.seekp((1 + 2) * hdr.block_size, ios::beg);
	file.write((char*)mainmap, hdr.block_size);
	printf("state: %u\n", file.rdstate());
	printf("wrote mainmap\n");
	printf("state: %u\n", file.rdstate());
	// write the postmap
	file.seekp((1 + postmap_loc) * hdr.block_size, ios::beg);
	file.write((char*)postmap, postmap_count * sizeof(p_map_t));
	file.write(nulls, file.tellp() % hdr.block_size == 0 ? 0 : hdr.block_size - (file.tellp() % hdr.block_size));

	printf("wrote postmap\n");
	printf("state: %u\n", file.rdstate());
	// write the post info
	file.seekp((1 + postinfo_loc) * hdr.block_size, ios::beg);
	file.write((char*)&postinfo, hdr.block_size);
	file.write(nulls, file.tellp() % hdr.block_size == 0 ? 0 : hdr.block_size - (file.tellp() % hdr.block_size));
	printf("state: %u\n", file.rdstate());
	printf("wrote postinfo\n");

	// write the post data
	file.seekp((1 + postdata_loc) * hdr.block_size, ios::beg);
	file.write((char*)postdata, sizeof(post_data_block) + postdata->post_len);
	offset = file.tellp();
	offset = offset % hdr.block_size;
	file.write(nulls, file.tellp() % hdr.block_size == 0 ? 0 : hdr.block_size - (file.tellp() % hdr.block_size));
	printf("state: %u\n", file.rdstate());
	printf("wrote postdata\n");
	printf("state: %u\n", file.rdstate());
	(*(long*)(&postheaders[4]))++;
	printf("funky thang worked\n");
	printf("state: %u\n", file.rdstate());

	offset = file.tellp();
	file.width(0);
	file.write((char*)postheaders, hdr.quick_send_len);
	file.write((char*)&postinfo.internal_id, 4);
	file.write((char*)&postinfo.date.base, 4);
	file.write((char*)&postinfo.date.sec, 4);
	file.write((char*)&postinfo.parent_thread, 4);
	file.write("\0\0\0\0", 4);
	file.write("\0\1", 2);
	file.write((char*)&postinfo.post_title_len, 1);
	file.write((char*)postinfo.post_title, postinfo.post_title_len);
	file.write((char*)&postinfo.author_len, 1);
	file.write((char*)postinfo.author, postinfo.author_len);
	file.write((char*)&postdata->mime_len, 1);
	file.write((char*)postdata->mime, postdata->mime_len);
	u_int16_t postlen = postdata->post_len;
	file.write((char*)&postlen, 2);

	hdr.num_objects = offset / hdr.block_size -1;
	hdr.quick_send_len = (unsigned int)file.tellp() - offset;

	// write the header
	hdr.post_count++;
	hdr.flag2++; // not sure about this one
	hdr.flag9++; // not sure about this one
	file.seekp(0, ios::beg);
	file.write((char*)&hdr, hdr.block_size);
	printf("wrote the header\n");
	printf("state: %u\n", file.rdstate());
	file.flush();
	file.close();

	printf("flushed and closed file\n");

	return true;
}


//-----------------------------------------------------------------------//
//create a new TNews File.
//-----------------------------------------------------------------------//   
bool NewsUtils::createNewsFile(const string &inPath, const string &inFileName)
{
	ofstream		file((inPath + inFileName).c_str(), ios::out | ios::binary);
	char			buffer[256];
	main_hdr_block	hdr;

#ifdef WIN32
	for(int i = 0 ; i < 256 ; i++ )
	{
		buffer[i] = 0;
	}
#else
	bzero(buffer, 256);
#endif//WIN32
#ifdef WIN32
	DEBUG_CALL(printf("entering createNewsFile\n"));
	memcpy(&hdr.magic, HLNZ_MAGIC, HLNZ_MAGIC_LEN);
	hdr.uuid.time_low = 0;
	hdr.uuid.time_mid = 0;
	hdr.uuid.time_hi_and_version = 0;
	hdr.uuid.clock_seq_hi_and_reserved = 0;
	hdr.uuid.clock_seq_low = 0;
	hdr.uuid.node[0] = 0;
	hdr.uuid.node[1] = 0;
	hdr.uuid.node[2] = 0;
	hdr.uuid.node[3] = 0;
	hdr.uuid.node[4] = 0;
	hdr.uuid.node[5] = 0;
	hdr.flag1 = ntohl(1);
	hdr.flag2 = ntohl(1);
	hdr.block_size = ntohl(256);
	hdr.num_objects = ntohl(3);//0;
	hdr.quick_send_len = ntohl(10);//0;
	hdr.post_count = 0;
	hdr.first_post_offset = 0;
	hdr.last_post_offset = 0;
	hdr.flag9 = ntohl(1);
	hdr.flag10 = ntohl(1);
	hdr.flag11 = ntohl(1);
	hdr.flag12 = ntohl(1);
	hdr.flag13 = ntohl(2);
	hdr.max_title_len = ntohl(31);//ntohl(163);
	hdr.unknown[0] = 0;
	hdr.unknown[1] = 0;
	hdr.unknown[2] = 0;
	hdr.cat_name_len = ntohl(inFileName.size() > ::htonl(hdr.max_title_len) ?
		::htonl(hdr.max_title_len) : inFileName.size());
	strncpy(hdr.category_name, inFileName.c_str(), ::htonl(hdr.max_title_len));
#else
	DEBUG_CALL(printf("entering createNewsFile\n"));
	memcpy(&hdr.magic, HLNZ_MAGIC, HLNZ_MAGIC_LEN);
	hdr.uuid.time_low = 0;
	hdr.uuid.time_mid = 0;
	hdr.uuid.time_hi_and_version = 0;
	hdr.uuid.clock_seq_hi_and_reserved = 0;
	hdr.uuid.clock_seq_low = 0;
	hdr.uuid.node[0] = 0;
	hdr.uuid.node[1] = 0;
	hdr.uuid.node[2] = 0;
	hdr.uuid.node[3] = 0;
	hdr.uuid.node[4] = 0;
	hdr.uuid.node[5] = 0;
	hdr.flag1 = 1;
	hdr.flag2 = 1;
	hdr.block_size = 256;
	hdr.num_objects = 0;
	hdr.quick_send_len = 0;
	hdr.post_count = 0;
	hdr.first_post_offset = 0;
	hdr.last_post_offset = 0;
	hdr.flag9 = 1;
	hdr.flag10 = 1;
	hdr.flag11 = 1;
	hdr.flag12 = 1;
	hdr.flag13 = 2;
	hdr.max_title_len = 163;
	hdr.unknown[0] = 0;
	hdr.unknown[1] = 0;
	hdr.unknown[2] = 0;
	hdr.cat_name_len = inFileName.size() > hdr.max_title_len ?
	hdr.max_title_len : inFileName.size();
	strncpy(hdr.category_name, inFileName.c_str(), hdr.max_title_len);
#endif

	//file.exceptions(ios::failbit);

	DEBUG_CALL(printf("file.seekp\n"));
#ifdef WIN32
	file.write((char*)&hdr, ::htonl(hdr.block_size) - 132);
	file.write(buffer , 132);
#else
	file.write((char*)&hdr, hdr.block_size);
#endif
	DEBUG_CALL(printf("wrote header\n"));
	file.write(buffer, 256);
	buffer[0] = 0xC0;
	file.write(buffer, 256);
	DEBUG_CALL(printf("wrote buffers\n"));
#ifdef WIN32
	buffer[0] = 0;
	file.write(buffer, 256);
	file.write(buffer, 10 );
#endif//WIN32

	file.close();
	return true;
}

#if 1
bool NewsUtils::getPostHeaders(const string &inPath, HLPacket &ioPacket)
{
	ifstream		file(inPath.c_str(), ios::in | ios::binary);
	main_hdr_block	catHdr;
	u_int8_t*		objectdata;
	//post_info_block	postinfo;
	//post_data_block	postdata;

	if (!file)
		return false;	// cant open file

	// throw exceptions for all errors
	file.exceptions(/*ios::eofbit | ios::failbit |*/ ios::badbit);

	if (getFileHeader(file, catHdr) == false)
		return false;

#ifdef WIN32
	catHdr.quick_send_len = htonl(catHdr.quick_send_len);
	catHdr.block_size			= htonl(catHdr.block_size);
	catHdr.num_objects		= htonl(catHdr.num_objects);
	catHdr.post_count = htonl(catHdr.post_count);
	catHdr.first_post_offset = htonl(catHdr.first_post_offset);
	catHdr.last_post_offset = htonl(catHdr.last_post_offset);
	catHdr.max_title_len = htonl(catHdr.max_title_len);
	catHdr.cat_name_len = htonl(catHdr.cat_name_len);
#endif

	file.seekg((1 + catHdr.num_objects) * catHdr.block_size, ios::beg);
	objectdata = (u_int8_t*)malloc(catHdr.quick_send_len);
	DEBUG_CALL(printf("did malloc\n"));
	DEBUG_CALL(printf("did seek\n"));
	file.read((char *)objectdata, catHdr.quick_send_len);

	DEBUG_CALL(printf("this is a valid news file\n"));

	// actually.. if the size of the headers is over 64k i should send the last 64k worth, not the first 64k... - jcb
	ioPacket.AddObject(HTLS_DATA_NEWS_CATLIST, catHdr.quick_send_len > 65535 ? 65535 : catHdr.quick_send_len, (char *)objectdata);

	free(objectdata);
	return true;
}

#else
/* dont mind this, tis for testing d:) */
bool NewsUtils::getPostHeaders(const string &inPath, HLPacket &ioPacket)
{
	u_int8_t		o[256];

	// constant
	o[0] = 0;
	o[1] = 0;
	o[2] = 0;
	o[3] = 0;

	// total threads
	o[4] = 0;
	o[5] = 0;
	o[6] = 0;
	o[7] = 1;

	// constant
	o[8] = 0;
	o[9] = 0;

	// thread id
	o[10] = 0;
	o[11] = 0;
	o[12] = 0;
	o[13] = 1;

	// base time
	o[14] = 0x07;
	o[15] = 0x70;
	o[16] = 0x00;
	o[17] = 0x00;

	// time
	o[18] = 0xB9;
	o[19] = 0x00;
	o[20] = 0xB7;
	o[21] = 0xBD;

	// parent thread
	o[22] = 0;
	o[23] = 0;
	o[24] = 0;
	o[25] = 0;

	// constant
	o[26] = 0;
	o[27] = 0;
	o[28] = 0;
	o[29] = 0;

	// element count
	o[30] = 0;
	o[31] = 1;

	// title
	o[32] = 1;
	o[33] = '1';

	// author
	o[34] = 1;
	o[35] = 'X';

	// mime type
	o[36] = 10;
	o[37] = 't';
	o[38] = 'e';
	o[39] = 'x';
	o[40] = 't';
	o[41] = '/';
	o[42] = 'p';
	o[43] = 'l';
	o[44] = 'a';
	o[45] = 'i';
	o[46] = 'n';

	// post len
	o[47] = 0;
	o[48] = 1;

	ioPacket.AddObject(HTLS_DATA_NEWS_CATLIST, 49, (char *)o);

	o[13] = 2;

	ioPacket.AddObject(HTLS_DATA_NEWS_CATLIST, 49, (char *)o);

	return true;
}
#endif

bool NewsUtils::getPostData(const string &inPath, u_int16_t inThreadID, HLPacket &ioPacket)
{
	ifstream file(inPath.c_str(), ios::in | ios::binary);
	main_hdr_block	catHdr;
	main_map_block	main_map;
	post_map_block	post_map;
	post_info_block	navpost;

	if (!file)
		return false;	// cant open file

	// throw exceptions for all errors
	file.exceptions(ios::eofbit | ios::failbit | ios::badbit);

	int	offset;
	if (getFileHeader(file, catHdr) == false)
		return false;

	DEBUG_CALL(printf("read header\n"));

#ifdef WIN32
	catHdr.quick_send_len = htonl(catHdr.quick_send_len);
	catHdr.block_size			= htonl(catHdr.block_size);
	catHdr.num_objects		= htonl(catHdr.num_objects);
	catHdr.post_count = htonl(catHdr.post_count);
	catHdr.first_post_offset = htonl(catHdr.first_post_offset);
	catHdr.last_post_offset = htonl(catHdr.last_post_offset);
	catHdr.max_title_len = htonl(catHdr.max_title_len);
	catHdr.cat_name_len = htonl(catHdr.cat_name_len);
#endif

	file.seekg((long)3*catHdr.block_size, ios::beg);
	file.read((char *)&main_map, sizeof(main_map));

	int n;

	// step through the main map
	for (n = 0; n < 32; n++)
	{
		if (htonl(main_map.map[n].map_count) > 0)
		{

			// find and read the post map
			DEBUG_CALL(printf("main_map.map[%u].map_count = %u\n", n, htonl(main_map.map[n].map_count)));
			offset = (1 + htonl(main_map.map[n].block_offset)) * catHdr.block_size;
			file.seekg(offset, ios::beg);
			file.read((char *)&post_map, sizeof(post_map));

			unsigned int m;
			post_info_block postinfo;
			//u_int8_t postinfo_data[256];
			//struct hl_news_thread_hdr *threadinfo = (struct hl_news_thread_hdr *)postinfo_data;
			post_data_block	postdata;
			u_int8_t *posttext;
#ifdef WIN32
			// step through the post map
			for (m = 0; m < htonl(main_map.map[n].map_count); m++)
			{
				if (htonl(post_map.map[m].id) == inThreadID) // we found the thread we want d:)
				{
					DEBUG_CALL(printf("post %u offset: %u\n", htonl(post_map.map[m].id), htonl(post_map.map[m].offset)));
					offset = (1 + htonl(post_map.map[m].offset)) * catHdr.block_size;
					file.seekg(offset, ios::beg);
					file.read((char *)&postinfo, sizeof(postinfo));

					offset = (1 + htonl(postinfo.data_offset)) * catHdr.block_size;
					file.seekg(offset, ios::beg);
					file.read((char *)&postdata, sizeof(postdata));

					file.seekg( -4 , ios::cur  );//added by ortana.
					// it would probably be a REALLY good idea to limit the post text size
					// the max size of an HL object (64k) would be a good choice --jcb
					DEBUG_CALL(printf("posttext = malloc(%u)\n", htonl(postdata.post_len)));
					posttext = (u_int8_t*)malloc(htonl(postdata.post_len));
					file.read((char *)posttext, htonl(postdata.post_len));
					ioPacket.AddObject(HTLS_DATA_NEWS_POST, htonl(postdata.post_len), (char *)posttext);
					free(posttext);
					DEBUG_CALL(printf("freed posttext\n"));

					if(htonl(postinfo.previous_thread)) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + htonl(postinfo.previous_thread)) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_PREVTHREADID, htonl(navpost.internal_id));

					if(htonl(postinfo.next_thread)) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + htonl(postinfo.next_thread)) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_NEXTTHREADID, htonl(navpost.internal_id));

					if(postinfo.parent_thread) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + htonl(postinfo.parent_thread)) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_PARENTTHREADID, htonl(navpost.internal_id));

					if(postinfo.reply_thread) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + htonl(postinfo.reply_thread)) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_NEXTSUBTHREADID, htonl(navpost.internal_id));

					ioPacket.AddObject(HTLS_DATA_NEWS_SUBJECT, postinfo.post_title_len, (char*)postinfo.post_title);
					ioPacket.AddObject(HTLS_DATA_NEWS_POSTER, postinfo.author_len, (char*)postinfo.author);
					ioPacket.AddStringObject(HTLS_DATA_NEWS_MIMETYPE, "text/plain", false); // this should be read from the post info, and not assumed --jcb
				}
			}
#else
			for (m = 0; m < main_map.map[n].map_count; m++)
			{
				if (post_map.map[m].id == inThreadID) // we found the thread we want d:)
				{
					DEBUG_CALL(printf("post %u offset: %u\n", post_map.map[m].id, post_map.map[m].offset));
					offset = (1 + post_map.map[m].offset) * catHdr.block_size;
					file.seekg(offset, ios::beg);
					file.read((char *)&postinfo, sizeof(postinfo));

					offset = (1 + postinfo.data_offset) * catHdr.block_size;
					file.seekg(offset, ios::beg);
					file.read((char *)&postdata, sizeof(postdata));

					// it would probably be a REALLY good idea to limit the post text size
					// the max size of an HL object (64k) would be a good choice --jcb
					DEBUG_CALL(printf("posttext = malloc(%u)\n", postdata.post_len));
					posttext = (u_int8_t*)malloc(postdata.post_len);
					file.read((char *)posttext, postdata.post_len);
					ioPacket.AddObject(HTLS_DATA_NEWS_POST, postdata.post_len, (char *)posttext);
					free(posttext);
					DEBUG_CALL(printf("freed posttext\n"));

					if(postinfo.previous_thread) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + postinfo.previous_thread) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_PREVTHREADID, navpost.internal_id);

					if(postinfo.next_thread) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + postinfo.next_thread) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_NEXTTHREADID, navpost.internal_id);

					if(postinfo.parent_thread) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + postinfo.parent_thread) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_PARENTTHREADID, navpost.internal_id);

					if(postinfo.reply_thread) // we only want to read from the file if it's a valid block id
					{
						offset = (1 + postinfo.reply_thread) * catHdr.block_size;
						file.seekg(offset, ios::beg);
						file.read((char *)&navpost, sizeof(navpost));
					}
					else
					{
						navpost.internal_id = 0;
					}
					ioPacket.AddUInt16Object(HTLS_DATA_NEWS_NEXTSUBTHREADID, navpost.internal_id);

					ioPacket.AddObject(HTLS_DATA_NEWS_SUBJECT, postinfo.post_title_len, (char*)postinfo.post_title);
					ioPacket.AddObject(HTLS_DATA_NEWS_POSTER, postinfo.author_len, (char*)postinfo.author);
					ioPacket.AddStringObject(HTLS_DATA_NEWS_MIMETYPE, "text/plain", false); // this should be read from the post info, and not assumed --jcb
				}
			}
#endif

		}
	}

	return true;
}

#endif // CONFIG_THREADEDNEWS

