#include "HLPacket.h"

HLPacket::HLPacket()
	: mType(0), mID(0), mFlag(0)
{
}

HLPacket::HLPacket(u_int32_t inType, u_int32_t inID, u_int32_t inFlag)
	: mType(inType), mID(inID), mFlag(inFlag)
{
}

HLPacket::~HLPacket()
{
	Clear();
}

void HLPacket::SetHeader(HL_PACKET_HEADER *ioHdr)
{
	mType = ioHdr->type = ntohl(ioHdr->type);
	mID = ioHdr->id = ntohl(ioHdr->id);
	mFlag = ioHdr->flag = ntohl(ioHdr->flag);
	ioHdr->size1 = ntohl(ioHdr->size1);
	ioHdr->size2 = ntohl(ioHdr->size2);
}

u_int32_t HLPacket::GetType() const
{
	return mType;
}

u_int32_t HLPacket::GetID() const
{
	return mID;
}

u_int32_t HLPacket::GetFlag() const
{
	return mFlag;
}

void HLPacket::Flatten(char *outBytes, u_int32_t &ioSize, u_int32_t inID) throw (logic_error)
{
	HL_PACKET_HEADER *hdr;
	u_int32_t pos;
	
    if (ioSize >= GetSize())
	{
        pos = 0;
        
        hdr = (HL_PACKET_HEADER *)&outBytes[pos];
        hdr->type = htonl(mType);
        if (inID)
            hdr->id = htonl(inID);
        else
            hdr->id = htonl(mID);
        hdr->flag = htonl(mFlag);
        hdr->size1 = hdr->size2 = htonl(HLObjectList::GetSize());
        pos += sizeof(HL_PACKET_HEADER);
		HLObjectList::Flatten(&outBytes[pos], ioSize);
		ioSize = GetSize();
	}
    else
        throw logic_error("buffer too small");
}

void HLPacket::Clear()
{
	// reset header, and clear objects
	mType = 0;
	mID = 0;
	mFlag = 0;
	HLObjectList::Clear();
}


