#include <string>
#include "FileUtils.h"

using namespace std;


#ifdef WIN32

//deleted by ortana.
#else//WIN32

int recursive_rmdir(const string &inPath)
{
    // function copied from hxd
    DIR *dir;
    struct dirent *de;
    string newPath;
    struct stat sb;
    int err = 0;

    dir = opendir(inPath.c_str());
    if (!dir)
        return 1;
    
    while ((de = readdir(dir)) && err == 0)
    {
        if (de->d_name[0] == '.' && ((de->d_name[1] == '.' && !de->d_name[2]) || !de->d_name[1]))
            continue;
        newPath.assign(inPath);
        newPath.push_back(DIRCHAR);
        newPath.append(de->d_name);
        if (!(err = lstat(newPath.c_str(), &sb)))
        {
            if (S_ISDIR(sb.st_mode) && !S_ISLNK(sb.st_mode))
                err = recursive_rmdir(newPath);
            else
                err = unlink(newPath.c_str());
        }
    }
    
    if (err == 0)
    {
        closedir(dir);
        return rmdir(inPath.c_str());
    }
    else
    {
        closedir(dir);
        return err;
    }
}

bool FileUtils::deletePath(const string &inPath)
{
    string rmPath(inPath);
    struct stat sb;
    int err;
    
    err = lstat(rmPath.c_str(), &sb);
    if (err != 0)
    {
        rmPath.append(".hpf");
        err = lstat(rmPath.c_str(), &sb);
    }
    
    if (err == 0)
    {
        if (S_ISDIR(sb.st_mode) && !S_ISLNK(sb.st_mode))
            err = recursive_rmdir(rmPath);
        else
            err = unlink(rmPath.c_str());
        
        if (err == 0)
        {
            return true;
        }
    }

    DEBUG_CALL(printf("error deleting path(%s): %s\n", rmPath.c_str(), strerror(errno)));
    return false;
}
#endif // !WIN32

#if _CARBON_

void FileUtils::FSRefToPath(const FSRef inRef, string &outPath)
{
    // FSRefMakePath returns a UTF-8 encoded string,
    // which may cause problems in other code, must test
    UInt8 path[MAXPATHLEN];
    OSStatus status = FSRefMakePath(&inRef, path, MAXPATHLEN);
    if (status == noErr)
    {
        outPath.assign((char *)path);
    }
    else
    {
        DEBUG_CALL(printf("FSRefToPath error: %d\n", (int)status); fflush(stdout));
    }
}

bool FileUtils::PathToFSRef(const string &inPath, FSRef *outRef)
{
    OSStatus status = FSPathMakeRef((UInt8 *)inPath.c_str(), outRef, NULL /*isDirectory*/);
    if (status != noErr)
    {
        DEBUG_CALL(printf("PathToFSRef error: %d path: %s\n",
            (int)status, inPath.c_str()); fflush(stdout));
        return false;
    }
    return true;
}

void FileUtils::resolveAlias(string &ioPath)
{
    FSRef theRef;
    Boolean targetIsFolder;
    Boolean wasAliased;
    if (PathToFSRef(ioPath, &theRef))
    {
        if (FSResolveAliasFile(&theRef, true, &targetIsFolder, &wasAliased) == noErr)
        {
            if (wasAliased)
            {
                FSRefToPath(theRef, ioPath);
                DEBUG_CALL(printf("alias path: %s\n", ioPath.c_str()); fflush(stdout));
            }
        }
    }
}

#endif // _CARBON_

