// A wrapper around AsyncTCPSocket that buffers reads and writes
// This is used by HLSocket to reliably send and recv packets

#ifndef BUFFERED_SOCKET_H
#define BUFFERED_SOCKET_H

#include "AsyncTCPSocket.h"
#include "DynamicBuffer.h"

class BufferedSocket : public AsyncTCPSocket
{
    public:
		BufferedSocket();
        BufferedSocket(int inDescriptor, struct sockaddr_in* inRemoteAddress);
        virtual ~BufferedSocket();
        
        void BufferedSend(const char *inBytes, u_int32_t inCount);
        
    protected:
        DynamicBuffer mWriteBuf;
        DynamicBuffer mReadBuf;
        
        virtual void DataAvailable() {}
        
        // if you override these, you'll want to call them
        virtual void OnRecv();
        virtual void OnSend();
        virtual void OnClose();
};

#endif // BUFFERED_SOCKET_H


