using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using WinTabDotnet;

namespace OutInfo {
    public partial class Form1 : Form {
        private WinTabMessenger  m_wtMessenger;
        private WinTabContext    m_wtContext;

        public Form1() {
            InitializeComponent();
            if (!WinTab.LoadWinTabLibrary()) {
                MessageBox.Show("y^ubg܂(WinTab32.dll܂)B","WinTab.NET");
                throw new WinTabException("WinTab.NET̏Ɏs܂B");
            }

            m_wtMessenger = new WinTabMessenger();
            m_wtContext = new WinTabContext();

            this.Text = WinTab.DeviceName + " Sample";
            lbWinTabID.Text     = WinTab.WinTabID;
            lbDeviceName.Text   = WinTab.DeviceName;
            ctlPrsProgress.Maximum = WinTab.DeviceNPressure.axMax;

            m_wtMessenger.CursorMove += delegate(PacketEventArgs e) { lbPosition.Text = e.pkts.pkX.ToString() + "," + e.pkts.pkY.ToString() + "," + e.pkts.pkZ.ToString(); };
            m_wtMessenger.NPressureChange += delegate(PacketEventArgs e) { lbPressure.Text = e.pkts.pkNormalPressure.ToString(); ctlPrsProgress.Value = e.pkts.pkNormalPressure; };
            m_wtMessenger.CursorChange += delegate(PacketEventArgs e) { lbCursor.Text = e.pkts.pkCursor.ToString(); };
            m_wtContext.Open(this.Handle,true);
        }

        protected override void WndProc(ref Message m) {
            if (!m_wtMessenger.WndProc(ref m)) { base.WndProc(ref m); }
        }
    }
}