//
// RawSocket.cpp
//
// $Id: //poco/1.4/Net/src/RawSocket.cpp#1 $
//
// Library: Net
// Package: Sockets
// Module:  RawSocket
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Net/RawSocket.h"
#include "Poco/Net/RawSocketImpl.h"
#include "Poco/Exception.h"


using Poco::InvalidArgumentException;


namespace Poco {
namespace Net {


RawSocket::RawSocket(): 
	Socket(new RawSocketImpl)
{
}


RawSocket::RawSocket(IPAddress::Family family, int proto): 
	Socket(new RawSocketImpl(family, proto))
{
}


RawSocket::RawSocket(const SocketAddress& address, bool reuseAddress): 
	Socket(new RawSocketImpl)
{
	bind(address, reuseAddress);
}


RawSocket::RawSocket(const Socket& socket): Socket(socket)
{
	if (!dynamic_cast<RawSocketImpl*>(impl()))
		throw InvalidArgumentException("Cannot assign incompatible socket");
}


RawSocket::RawSocket(SocketImpl* pImpl): Socket(pImpl)
{
	if (!dynamic_cast<RawSocketImpl*>(impl()))
		throw InvalidArgumentException("Cannot assign incompatible socket");
}


RawSocket::~RawSocket()
{
}


RawSocket& RawSocket::operator = (const Socket& socket)
{
	if (dynamic_cast<RawSocketImpl*>(socket.impl()))
		Socket::operator = (socket);
	else
		throw InvalidArgumentException("Cannot assign incompatible socket");
	return *this;
}


void RawSocket::connect(const SocketAddress& address)
{
	impl()->connect(address);
}


void RawSocket::bind(const SocketAddress& address, bool reuseAddress)
{
	impl()->bind(address, reuseAddress);
}


int RawSocket::sendBytes(const void* buffer, int length, int flags)
{
	return impl()->sendBytes(buffer, length, flags);
}


int RawSocket::receiveBytes(void* buffer, int length, int flags)
{
	return impl()->receiveBytes(buffer, length, flags);
}


int RawSocket::sendTo(const void* buffer, int length, const SocketAddress& address, int flags)
{
	return impl()->sendTo(buffer, length, address, flags);
}


int RawSocket::receiveFrom(void* buffer, int length, SocketAddress& address, int flags)
{
	return impl()->receiveFrom(buffer, length, address, flags);
}


} } // namespace Poco::Net
