//
// RotateStrategy.cpp
//
// $Id: //poco/1.4/Foundation/src/RotateStrategy.cpp#1 $
//
// Library: Foundation
// Package: Logging
// Module:  FileChannel
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/RotateStrategy.h"
#include "Poco/FileStream.h"
#include "Poco/DateTimeParser.h"
#include "Poco/DateTimeFormatter.h"
#include "Poco/DateTimeFormat.h"


namespace Poco {


//
// RotateStrategy
//


RotateStrategy::RotateStrategy()
{
}


RotateStrategy::~RotateStrategy()
{
}


//
// RotateByIntervalStrategy
//


const std::string RotateByIntervalStrategy::ROTATE_TEXT("# Log file created/rotated ");


RotateByIntervalStrategy::RotateByIntervalStrategy(const Timespan& span): 
	_span(span),
	_lastRotate(0)
{
	if (span.totalMicroseconds() <= 0) throw InvalidArgumentException("time span must be greater than zero");
}


RotateByIntervalStrategy::~RotateByIntervalStrategy()
{
}


bool RotateByIntervalStrategy::mustRotate(LogFile* pFile)
{
	if (_lastRotate == 0 || pFile->size() == 0)
	{
		if (pFile->size() != 0)
		{
			Poco::FileInputStream istr(pFile->path());
			std::string tag;
			std::getline(istr, tag);
			if (tag.compare(0, ROTATE_TEXT.size(), ROTATE_TEXT) == 0)
			{
				std::string timestamp(tag, ROTATE_TEXT.size());
				int tzd;
				_lastRotate = DateTimeParser::parse(DateTimeFormat::RFC1036_FORMAT, timestamp, tzd).timestamp();
			}
			else _lastRotate = pFile->creationDate();
		}
		else
		{
			_lastRotate.update();
			std::string tag(ROTATE_TEXT);
			DateTimeFormatter::append(tag, _lastRotate, DateTimeFormat::RFC1036_FORMAT);
			pFile->write(tag);
		}
	}
	Timestamp now;
	return _span <= now - _lastRotate;
}


//
// RotateBySizeStrategy
//


RotateBySizeStrategy::RotateBySizeStrategy(UInt64 size): _size(size)
{
	if (size == 0) throw InvalidArgumentException("size must be greater than zero");
}


RotateBySizeStrategy::~RotateBySizeStrategy()
{
}


bool RotateBySizeStrategy::mustRotate(LogFile* pFile)
{
	return pFile->size() >= _size;
}


} // namespace Poco
