//
// Twitter.h
//
// $Id: //poco/1.4/Net/samples/TwitterClient/src/Twitter.h#1 $
//
// A C++ implementation of a Twitter client based on the POCO Net library.
//
// Copyright (c) 2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Twitter_INCLUDED
#define Twitter_INCLUDED


#include "Poco/Poco.h"
#include "Poco/Net/HTMLForm.h"
#include "Poco/DOM/Document.h"
#include "Poco/AutoPtr.h"


class Twitter
	/// A simple implementation of a Twitter API client
	/// (see <http://apiwiki.twitter.com> for more information).
	/// 
	/// Currently, only the update message is supported.
{
public:
	Twitter();
		/// Creates the Twitter object, using
		/// the default Twitter API URI (<http://twitter.com/statuses/>).
		
	Twitter(const std::string& twitterURI);
		/// Creates the Twitter object using the given URI.
		
	~Twitter();
		/// Destroys the Twitter object.
		
	void login(const std::string& username, const std::string& password);
		/// Specifies the username and password used in all API calls that
		/// require authentication.
		
	Poco::Int64 update(const std::string& status);
		/// Updates the user's status.
		///
		/// Returns the ID of the newly created status.

	Poco::AutoPtr<Poco::XML::Document> invoke(const std::string& httpMethod, const std::string& twitterMethod, Poco::Net::HTMLForm& params);
		/// Invokes the given method of the Twitter API, using the parameters
		/// given in the Poco::Net::HTMLForm object. httpMethod must be GET or POST,
		/// according to the Twitter API documentation.
		///
		/// Returns an XML DOM document containing the server's response if the
		/// server's HTTP response status code is 200 (OK).
		/// Otherwise, throws a Poco::ApplicationException.
	
	static const std::string TWITTER_URI;

private:
	Twitter(const Twitter&);
	Twitter& operator = (const Twitter&);
	
	std::string _uri;
	std::string _username;
	std::string _password;
};


#endif // Twitter_INCLUDED
