/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.utils.MathUtils;

public class DriverRectangleTikz
implements UDriver<URectangle, TikzGraphics> {
    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        double width = rect.getWidth();
        double height = rect.getHeight();
        double r = MathUtils.min(rect.getRx(), rect.getRy(), width / 2.0, height / 2.0);
        HColor back = param.getBackcolor();
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            tikz.setGradientColor(gr.getColor1(), gr.getColor2(), gr.getPolicy());
        } else {
            tikz.setFillColor(back);
        }
        tikz.setStrokeColor(param.getColor());
        tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
        if (r == 0.0) {
            tikz.rectangle(x, y, width, height);
        } else {
            tikz.rectangleRound(x, y, width, height, r);
        }
    }
}

