/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.Log;

public class SpriteImage
implements Sprite {
    private final UImage img;

    public SpriteImage(BufferedImage img) {
        this.img = new UImage(new PixelImage(Objects.requireNonNull(img), AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ColorMapper colorMapper = ug.getColorMapper();
                if (colorMapper == ColorMapper.MONOCHROME) {
                    ug.draw(SpriteImage.this.img.monochrome().scale(scale));
                } else if (color == null) {
                    ug.draw(SpriteImage.this.img.scale(scale));
                } else {
                    ug.draw(SpriteImage.this.img.muteColor(color.toColor(colorMapper)).scale(scale));
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D((double)SpriteImage.this.img.getWidth() * scale, (double)SpriteImage.this.img.getHeight() * scale);
            }
        };
    }

    public static Sprite fromInternal(String name) {
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException();
        }
        InputStream is = SpriteImage.getInternalSprite(name + ".png");
        if (is == null) {
            return null;
        }
        try {
            return new SpriteImage(SImageIO.read(is));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    public static InputStream getInternalSprite(String inner) {
        String path = "/sprites/" + inner;
        Log.info("Triying " + path);
        InputStream is = SpriteImage.class.getResourceAsStream(path);
        return is;
    }
}

