#pragma once

//////////////////////////////////////////////////////////////////////////

#include "Interlocked.h"
#include "Types.h"
#include "Stopwatch.h"
#include "StringConvert.h"
#include <afxmt.h>
#include <process.h>	// For _beginthreadex

//////////////////////////////////////////////////////////////////////////

class CWcsAPI
{
public:
	CWcsAPI() {}
	virtual ~CWcsAPI() {}

public:
	// WinCS API
	virtual BOOL API_StartPlugin(WORD wPluginID, const CByteArray &arg)
	{ return FALSE; }
	virtual BOOL API_StopPlugin(double dbRuntime)			// For Single mode or Slave
	{ return FALSE; }
	virtual BOOL API_StopPlugin(const CalcReportList &list)	// For System mode
	{ return FALSE; }
	virtual BOOL API_Broadcast(const CByteArray &data)
	{ return FALSE; }
	virtual BOOL API_SendToMaster(const CByteArray &data)
	{ return FALSE; }
	virtual BOOL API_CreateGraphWindow(const CString &csName, int cx, int cy, BOOL bFront)
	{ return FALSE;}
	virtual BOOL API_SetPixel(int x, int y, COLORREF color)
	{ return FALSE;}
	virtual BOOL API_SetXLine(int y, int cx, LPCOLORREF lpColor)
	{ return FALSE;}
	virtual BOOL API_SetYLine(int x, int cy, LPCOLORREF lpColor)
	{ return FALSE;}
	virtual BOOL API_SetTaskSchedule(const NodeInitList &list)
	{ return FALSE; }
	virtual void API_SetProgress(DWORD dwIndex, int nPoint)
	{}
	virtual void API_InitProgress(DWORD dwProcessors)
	{}
	virtual void API_SetGraphWindowSize(int cx, int cy, int x, int y)
	{}
	virtual void API_SetCenterWindow()
	{}
	virtual void API_ResetWindow()
	{}
	virtual void API_StartTimer()
	{}
	virtual void API_StopTimer()
	{}
};

//////////////////////////////////////////////////////////////////////////

// Base class
class CPlugin : public CStringConvert
{
protected:
	explicit CPlugin();
	virtual ~CPlugin();

public:
	// Override function
	virtual BOOL  LoadInitialize() { return TRUE; }
	virtual void  ReceiveCallBack(const CByteArray &data) {}
	
	virtual BOOL  MasterInitialize(const NodeDataList &list, BOOL fSystem) { return TRUE; }
	virtual BOOL  MasterFinalize() { return TRUE; }	
	virtual DWORD MasterTransaction(LPVOID lpParams = NULL);
	
	virtual BOOL  SlaveInitialize(const SLAVE_PLUGIN &init);
	virtual BOOL  SlaveFinalize() { return TRUE; }
	virtual DWORD SlaveTransaction(LPVOID lpParams = NULL);

public:
	BOOL StartPlugin(const CByteArray &arg);
	BOOL CancelPlugin(DWORD dwTimeout);
	void GetPluginInfo(LPPLUGIN_INFO lpInfo);
	void SetAPI(CWcsAPI *pAPI) { m_pAPI = pAPI; }
	void SetCalcSize(CALCSIZE size) { m_CalcSize = size; }
	void GetCalcSize(CALCSIZE &size) { size = m_CalcSize; }
	BOOL IsMaster() { return m_fMaster; }

	// WinCS API wrapper
	// Master function
	BOOL API_StartPlugin(WORD wPluginID, const CByteArray &arg);
	BOOL API_StopPlugin(double dbRuntime);
	BOOL API_StopPlugin(const CalcReportList &list);
	BOOL API_Broadcast(const CByteArray &data);
	BOOL API_CreateGraphWindow(const CString &csName, int cx, int cy, BOOL bFront = FALSE);
	BOOL API_SetPixel(int x, int y, COLORREF color);
	BOOL API_SetXLine(int y, int cx, LPCOLORREF lpColor);
	BOOL API_SetYLine(int x, int cy, LPCOLORREF lpColor);
	BOOL API_SetTaskSchedule(const NodeInitList &list);
	void API_SetGraphWindowSize(int cx, int cy, int x = 0, int y = 0);
	void API_SetCenterWindow();
	void API_ResetWindow();
	void API_StartTimer();
	void API_StopTimer();

	// Slave function
	BOOL API_SendToMaster(const CByteArray &data);
	void API_SetProgress(DWORD dwIndex, int nPoint);
	void API_InitProgress(DWORD dwProcessors);

protected:
	typedef CZeroEvent<SHORT> ZeroEvent;
	typedef CArray<ZeroEvent> EventList;

	void SetCalcReport(DWORD dwIndex, double dbRuntime);
	BOOL doCreateWindow(const MASTER_PLUGIN &init);
	static DWORD WINAPI doMasterTransaction(LPVOID lpParams);
	static DWORD WINAPI doSlaveTransaction(LPVOID lpParams);

private:
	void CloseHandleList(BOOL fWait = FALSE, DWORD dwMilliseconds = INFINITE);
	void ThreadFinish();

protected:
	typedef struct _PLUGIN_PARAMS
	{
		CPlugin    *obj;
		DWORD	   dwIndex;
		DWORD	   dwAffinity;
		DWORD      dwThdCount;
		BOOL	   fAlive;
		BOOL	   fSystem;
		CByteArray arg;
	}
	PLUGIN_PARAMS, *LPPLUGIN_PARAMS;

	typedef struct _THREAD_COUNT
	{
		ATM_DWORD dwCount;
		ATM_DWORD dwFinish;
	}
	THREAD_COUNT, *LPTHREAD_COUNT;

	typedef struct _CALCCOUNT
	{
		ATM_DWORD dwFinCount;
		ATM_DWORD dwAllCount;
	}
	CALCCOUNT, *LPCALCCOUNT;

	typedef CArray<PLUGIN_PARAMS> PlgPrmList;

	CCriticalSection m_NetLock;
	CalcReportList   m_Reportlist;	// For Single mode
	NodeInitList     m_NodeInitList;	// For System mode
	PLUGIN_INFO      m_PlgInfo;
	CByteArray 	     m_Argument;
	CStopwatch	     m_Stopwatch;
	PlgPrmList	     m_PlgPrmList;
	HandleList	     m_ThdList;
	DWORDList	     m_ThdIDList;
	EventList	     m_EventList;
	CALCCOUNT	     m_CalcCount;
	CALCSIZE	     m_CalcSize;
	BOOL		     m_fRunning;
	BOOL		     m_fMaster;
	BOOL		     m_fSystem;

	MASTER_PLUGIN    m_MasterPlugin;
	SLAVE_PLUGIN     m_SlavePlugin;

private:
	CCriticalSection m_ThdLock;
	THREAD_COUNT     m_ThdCount;
	CWcsAPI		     *m_pAPI;
};

//////////////////////////////////////////////////////////////////////////

inline BOOL CPlugin::API_StartPlugin(WORD wPluginID, const CByteArray &arg)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_StartPlugin(wPluginID, arg);
}

inline BOOL CPlugin::API_StopPlugin(double dbRuntime)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_StopPlugin(dbRuntime);
}

inline BOOL CPlugin::API_StopPlugin(const CalcReportList &list)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_StopPlugin(list);
}

inline BOOL CPlugin::API_Broadcast(const CByteArray &data)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_Broadcast(data);
}

inline BOOL CPlugin::API_SendToMaster(const CByteArray &data)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_SendToMaster(data);
}

inline BOOL CPlugin::API_CreateGraphWindow(const CString &csName, int cx, int cy, BOOL bFront)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_CreateGraphWindow(csName, cx, cy, bFront);
}

inline BOOL CPlugin::API_SetPixel(int x, int y, COLORREF color)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_SetPixel(x, y, color);
}

inline BOOL CPlugin::API_SetXLine(int y, int cx, LPCOLORREF lpColor)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_SetXLine(y, cx, lpColor);
}

inline BOOL CPlugin::API_SetYLine(int x, int cy, LPCOLORREF lpColor)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_SetYLine(x, cy, lpColor);
}

inline BOOL CPlugin::API_SetTaskSchedule(const NodeInitList &list)
{
	ASSERT(m_pAPI);
	return m_pAPI->API_SetTaskSchedule(list); 
}

inline void CPlugin::API_SetProgress(DWORD dwIndex, int nPoint)
{
	ASSERT(m_pAPI);
	m_pAPI->API_SetProgress(dwIndex, nPoint);
}

inline void CPlugin::API_InitProgress(DWORD dwProcessors)
{
	ASSERT(m_pAPI);
	m_pAPI->API_InitProgress(dwProcessors);
}

inline void CPlugin::API_SetGraphWindowSize(int cx, int cy, int x, int y)
{
	ASSERT(m_pAPI);
	m_pAPI->API_SetGraphWindowSize(cx, cy, x, y);
}

inline void CPlugin::API_SetCenterWindow()
{
	ASSERT(m_pAPI);
	m_pAPI->API_SetCenterWindow();
}

inline void CPlugin::API_ResetWindow()
{
	ASSERT(m_pAPI);
	m_pAPI->API_ResetWindow();
}

inline void CPlugin::API_StartTimer()
{
	ASSERT(m_pAPI);
	m_pAPI->API_StartTimer();
}

inline void CPlugin::API_StopTimer()
{
	ASSERT(m_pAPI);
	m_pAPI->API_StopTimer();
}

//////////////////////////////////////////////////////////////////////////
