#pragma once

#define WCS_PLUGIN_TYPE_GRAPHICS	1
#define WCS_PLUGIN_TYPE_CONSOLE		2

#define WCS_BUILD_TYPE_RELEASE		1
#define WCS_BUILD_TYPE_DEBUG		2

//////////////////////////////////////////////////////////////////////////

typedef struct _BM_DATA
{
	WORD   wNodeID;
	DWORD  dwAddress;
	DWORD  dwProcessors;
	DWORD  dwIterations;
	double dbRlt1;
	double dbRlt2;
	double dbRlt3;
	double dbRlt4;
	double dbRltAvg;
	double dbRuntime;
	BOOL   fSet;
}
BM_DATA, *LPBM_DATA;

typedef struct _NODE_DATA
{
	DWORD	 dwAddress;
	WORD	 wPort;
	WORD	 wNodeID;
	WORD	 wNodeType;
	WORD	 wNodeState;
	DWORD	 dwProcessors;
	BM_DATA	 bm;
}
NODE_DATA, *LPNODE_DATA;

typedef struct _PLUGIN_INFO
{
	WORD  wPluginID;
	WORD  wType;
	WORD  wVersion;
	UINT  nBuildType;
	DWORD dwTimeout;
	TCHAR szText[512];
}
PLUGIN_INFO, *LPPLUGIN_INFO;

typedef struct _MASTER_SETTING
{
	BOOL fInternet;
	BOOL fRtRendering;
	BOOL fLogPlugin;
	UINT nConnections;
	UINT nProcessors;
	UINT nRecvCount;
	UINT nTotalCount;
}
MASTER_SETTING, *LPMASTER_SETTING;

typedef struct _SLAVE_SETTING
{
	BOOL fAutoDownload;
	UINT nProcessors;
}
SLAVE_SETTING, *LPSLAVE_SETTING;

typedef struct _CALCREPORT
{
	WORD   wNodeID;
	WORD   wSubID;
	DWORD  dwAddress;
	double dbRuntime;
}
CALCREPORT, *LPCALCREPORT;

typedef struct _CALCSIZE
{
	UINT nWidth;
	UINT nHeight;
	UINT nRange;
}
CALCSIZE, *LPCALCSIZE;

typedef struct _NODEINIT
{
	int    nIndex;
	int	   nYInit;
	int	   nStep;
	int	   nRange;
	WORD   wNodeID;
	WORD   wSubID;
	BOOL   fEnd;
	DWORD  dwAddress;
	double dbRuntime;
}
NODEINIT, *LPNODEINIT;

//////////////////////////////////////////////////////////////////////////

typedef unsigned (__stdcall *PTHREAD_START)(void *);	// Thread

typedef CArray<NODE_DATA>  NodeDataList;
typedef CArray<HANDLE>	   HandleList;
typedef CArray<DWORD>	   DWORDList;
typedef CArray<CALCREPORT> CalcReportList;
typedef CArray<NODEINIT>   NodeInitList;

typedef struct _MASTER_PLUGIN
{
	WORD		 wNodeID;
	DWORD		 dwAddress;
	DWORD		 dwProcessors;
	BOOL		 bSystem;
	BOOL		 bFront;
	UINT		 nPluginType;
	CString		 csWndName;
	NodeDataList list;
}
MASTER_PLUGIN, *LPMASTER_PLUGIN;

typedef struct _SLAVE_PLUGIN
{
	WORD   wNodeID;
	DWORD  dwProcessors;
	double dbRuntime;
}
SLAVE_PLUGIN, *LPSLAVE_PLUGIN;

//////////////////////////////////////////////////////////////////////////

typedef CInterlockedType<HANDLE>	ATM_HANDLE;
typedef CInterlockedScalar<WORD>	ATM_WORD;
typedef CInterlockedScalar<DWORD>	ATM_DWORD;
typedef CInterlockedScalar<double>	ATM_DOUBLE;

//////////////////////////////////////////////////////////////////////////

#define MC_MINSIZE(x, y)									\
	(sizeof(x) < sizeof(y)) ? sizeof(x) : sizeof(y)

#define MC_BEGINTHREADEX(psa, cbStack, pfnStartAddr,		\
	pvParam, fdwCreate, pdwThreadId)		\
	((HANDLE)_beginthreadex(				\
	(void *)        (psa),					\
	(unsigned)      (cbStack),				\
	(PTHREAD_START) (pfnStartAddr),			\
	(void *)        (pvParam),				\
	(unsigned)      (fdwCreate),			\
	(unsigned *)    (pdwThreadId)))

//////////////////////////////////////////////////////////////////////////
