#include "StdAfx.h"
#include "WcsAPI.h"

//////////////////////////////////////////////////////////////////////////
// Common

CPlugin::CPlugin() : 
	m_pAPI(NULL), 
	m_fMaster(FALSE),
	m_fSystem(FALSE),
	m_fRunning(FALSE)
{
	ZeroMemory(&m_SlavePlugin, sizeof(m_SlavePlugin));
	ZeroMemory(&m_CalcSize, sizeof(m_CalcSize));
}

CPlugin::~CPlugin()
{
}

void CPlugin::GetPluginInfo(LPPLUGIN_INFO lpInfo)
{ 
	CopyMemory(lpInfo, &m_PlgInfo, sizeof(PLUGIN_INFO));
}

BOOL CPlugin::StartPlugin(const CByteArray &arg)
{
	CSingleLock sl(&m_ThdLock, TRUE);
	DWORD dwCount;

	m_Argument.RemoveAll();
	m_Argument.Copy(arg);
	m_fRunning = TRUE;

	if (m_fMaster)
	{
		m_MasterPlugin.wNodeID	    = m_MasterPlugin.list[0].wNodeID;
		m_MasterPlugin.dwAddress	= m_MasterPlugin.list[0].dwAddress;
		m_MasterPlugin.dwProcessors = m_fSystem ? 1 : m_MasterPlugin.list[0].dwProcessors;
		dwCount = m_MasterPlugin.dwProcessors;

		if (!m_fSystem)
		{
			m_Reportlist.RemoveAll();
			m_Reportlist.SetSize(dwCount);
		}
	}
	else
	{
		dwCount = m_SlavePlugin.dwProcessors;
	}

	m_ThdCount.dwCount  = dwCount;
	m_ThdCount.dwFinish = 0;

	m_ThdList.SetSize(dwCount);
	m_ThdIDList.SetSize(dwCount);
	m_PlgPrmList.SetSize(dwCount);

	for (UINT i = 0; i < dwCount; i++)
	{
		m_PlgPrmList[i].obj        = this;
		m_PlgPrmList[i].dwIndex	   = i;
		m_PlgPrmList[i].dwAffinity = (0x0001 << i);
		m_PlgPrmList[i].dwThdCount = dwCount;
		m_PlgPrmList[i].fAlive	   = TRUE;
		m_PlgPrmList[i].fSystem	   = m_fSystem;
		m_PlgPrmList[i].arg.Copy(arg);

		m_ThdList[i] = MC_BEGINTHREADEX(NULL, 
							0,
							(m_fMaster ? doMasterTransaction : doSlaveTransaction),
							&m_PlgPrmList[i],
							CREATE_SUSPENDED,
							&m_ThdIDList[i]);
	}

	// Start thread
	for (UINT i = 0; i < dwCount; i++)
	{
		ResumeThread(m_ThdList[i]);
	}

	for (UINT i = 0; i < dwCount; i++)
	{
		if (m_ThdList[i] == NULL)
		{
			return FALSE;
		}
	}

	return TRUE;
}

void CPlugin::ThreadFinish()
{
	++m_ThdCount.dwFinish;

	if (m_ThdCount.dwCount == m_ThdCount.dwFinish)
	{
		if (m_fMaster)
		{
			MasterFinalize();
		}
		else
		{
			SlaveFinalize();
		}

		CloseHandleList();
		m_fRunning = FALSE;
	}
}

BOOL CPlugin::CancelPlugin(DWORD dwTimeout)
{
	CSingleLock sl(&m_ThdLock, TRUE);
	UINT  nSize = m_ThdIDList.GetSize();
	DWORD dwRet;

	if (nSize > 0)
	{
		m_fRunning = FALSE;
		dwRet = WaitForMultipleObjects(nSize, m_ThdList.GetData(), TRUE, dwTimeout);

		if (dwRet != WAIT_FAILED)
		{
			m_ThdList.RemoveAll();
			m_ThdIDList.RemoveAll();
			m_PlgPrmList.RemoveAll();
			return TRUE;
		}	
	}
	
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////
// Master

DWORD CPlugin::MasterTransaction(LPVOID lpParams)
{
	if (!m_fSystem)
	{
		// Single mode
		ThreadFinish();
	}

	return 0;
}

BOOL CPlugin::doCreateWindow(const MASTER_PLUGIN &init)
{
	m_CalcCount.dwAllCount = 0;
	m_CalcCount.dwFinCount = 0;
	m_MasterPlugin.csWndName = init.csWndName;
	m_MasterPlugin.bFront	   = init.bFront;
	m_MasterPlugin.list.Copy(init.list);
	m_fMaster  = TRUE;
	m_fSystem  = init.bSystem;
	m_NodeInitList.RemoveAll();
	CloseHandleList();

	CString csName = m_MasterPlugin.csWndName;
	BOOL	bFront = m_MasterPlugin.bFront;
	int		cx = m_CalcSize.nWidth;
	int		cy = m_CalcSize.nHeight;

	if (API_CreateGraphWindow(csName, cx, cy, bFront))
	{
		API_SetCenterWindow();
		return TRUE;
	}

	return FALSE;
}

DWORD WINAPI CPlugin::doMasterTransaction(LPVOID lpParams)
{
	// Master single mode
	LPPLUGIN_PARAMS p = (LPPLUGIN_PARAMS)lpParams;
	HANDLE hCurrent = GetCurrentThread();

	// Set Affinity
	if (SetThreadAffinityMask(hCurrent, p->dwAffinity) == 0)
	{
		TRACE2("***** ERROR: SetThreadAffinityMask(%d) Processor(%d)", GetLastError(), p->dwIndex);
		return 0;
	}
	/*if (SetThreadIdealProcessor(hCurrent, p->dwAffinity) == -1)
	{
		TRACE2("***** ERROR: SetThreadIdealProcessor(%d) Processor(%d)", GetLastError(), p->dwIndex);
		return 0;
	}*/

	return p->obj->MasterTransaction(lpParams);
}

//////////////////////////////////////////////////////////////////////////
// Slave

DWORD CPlugin::SlaveTransaction(LPVOID lpParams)
{
	return ThreadFinish(), 0;
}

BOOL CPlugin::SlaveInitialize(const SLAVE_PLUGIN &init)
{
	m_SlavePlugin = init;
	m_fMaster     = FALSE;
	m_SlavePlugin.dbRuntime = 0.0;
	CloseHandleList();
	return TRUE;
}

DWORD WINAPI CPlugin::doSlaveTransaction(LPVOID lpParams)
{
	LPPLUGIN_PARAMS p = (LPPLUGIN_PARAMS)lpParams;
	HANDLE hCurrent = GetCurrentThread();

	// Set Affinity
	if (SetThreadAffinityMask(hCurrent, p->dwAffinity) == 0)
	{
		TRACE2("***** ERROR: SetThreadAffinityMask(%d) Processor(%d)", GetLastError(), p->dwIndex);
		return 0;
	}
	/*if (SetThreadIdealProcessor(hCurrent, p->dwAffinity) == -1)
	{
		TRACE2("***** ERROR: SetThreadIdealProcessor(%d) Processor(%d)", GetLastError(), p->dwIndex);
		return 0;
	}*/

	return p->obj->SlaveTransaction(lpParams);
}

void CPlugin::CloseHandleList(BOOL fWait, DWORD dwMilliseconds)
{
	CSingleLock sl(&m_ThdLock, TRUE);
	UINT nSize = m_ThdList.GetSize();

	if (nSize > 0)
	{
		if (fWait)
		{
			for (UINT i = 0; i < nSize; i++)
			{
				m_PlgPrmList[i].fAlive = FALSE;
			}

			WaitForMultipleObjects(nSize, m_ThdList.GetData(), TRUE, dwMilliseconds);
		}

		for (UINT i = 0; i < nSize; i++)
		{
			CloseHandle(m_ThdList[i]);
		}

		m_ThdList.RemoveAll();
		m_ThdIDList.RemoveAll();
		m_PlgPrmList.RemoveAll();
	}
}

void CPlugin::SetCalcReport(DWORD dwIndex, double dbRuntime)
{
	UINT nSize = m_Reportlist.GetSize();

	if (m_fMaster && !m_fSystem && (nSize > dwIndex))
	{
		m_Reportlist[dwIndex].wNodeID	= m_MasterPlugin.wNodeID;
		m_Reportlist[dwIndex].wSubID	= static_cast<WORD>(dwIndex);
		m_Reportlist[dwIndex].dwAddress = m_MasterPlugin.dwAddress;
		m_Reportlist[dwIndex].dbRuntime = dbRuntime;
	}
}

//////////////////////////////////////////////////////////////////////////